package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.CodeNameParam;
import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Repository
public class SysPlatformAppRepoProc extends BaseRepoProc<SysPlatformAppDO> {
    private static final QSysPlatformAppDO QDO = QSysPlatformAppDO.sysPlatformAppDO;

    public SysPlatformAppRepoProc() {
        super(QDO);
    }

    /**
     * 所有启用状态的应用
     *
     * @return
     */
    public List<CodeNameParam> allEnabled() {
        return jpaQueryFactory.select(Projections.bean(CodeNameParam.class,
                        QDO.appCode.as("code"), QDO.appName.as("name")))
                .from(QDO)
                .where(QDO.appState.eq(true))
                .orderBy(QDO.appOrder.asc())
                .fetch();
    }

    /**
     * 分页查询管理
     *
     * @param param 查询参数
     * @return 应用列表
     */
    public PagingVO<SysPlatformAppDO> pageMng(QueryAppParam param) {
        var predicate = PredicateBuilder.builder()
                .andLike(QDO.appCode, param.getAppCode())
                .andLike(QDO.appName, param.getAppName())
                .build();
        return super.queryByPage(predicate, param.getPageRequest(), QDO.appOrder.desc());
    }

    /**
     * 分页查询管理
     *
     * @param param 查询参数
     * @return 应用列表
     */
    public PagingVO<SysPlatformAppDO> pageQuery(QueryAppParam param) {
        var predicate = PredicateBuilder.builder()
                .andLike(QDO.appCode, param.getAppCode())
                .andLike(QDO.appName, param.getAppName())
                .andEq(QDO.appState, true)
                .build();
        return super.queryByPage(predicate, param.getPageRequest(), QDO.appOrder.desc());
    }
}
