package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Repository
public interface SysPlatformMenusRepo extends JpaRepository<SysPlatformMenusDO, Long>,
        QuerydslPredicateExecutor<SysPlatformMenusDO> {
    List<SysPlatformMenusDO> findAllByMenusAppCode(String appCode);
    List<SysPlatformMenusDO> findAllByMenusParentCode(String menusCode);
    List<SysPlatformMenusDO> findAllByMenusCode(String menusCode);

    SysPlatformMenusDO findByMenusCode(String menusCode);

    List<SysPlatformMenusDO> findByMenusAppCode(String appCode);

    List<SysPlatformMenusDO> findAllByMenusTypeAndNodeTypeAndMenusStateAndDeleteFlag
            (String menusType, String nodeType, Boolean menusState, Integer deleteFlag);
    List<SysPlatformMenusDO> findAllByMenusTypeAndMenusStateAndDeleteFlag
            (String menusType,  Boolean menusState, Integer deleteFlag);
    List<SysPlatformMenusDO> findAllByMenusTypeAndDeleteFlag
            (String menusType,   Integer deleteFlag);
    List<SysPlatformMenusDO> findAllByMenusCodeIn(List<String> menusCode);

 }
