/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.develop.vo.SysDatabaseSourceVO;
import com.elitescloud.cloudt.tenant.convert.SysDatabaseSourceConvert;
import com.elitescloud.cloudt.tenant.model.entity.SysDatabaseSourceDO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceQueryParam;
import com.elitescloud.cloudt.tenant.model.vo.params.SysDatabaseSourceUpdateParam;
import com.elitescloud.cloudt.tenant.service.SysDatabaseSourceService;
import com.elitescloud.cloudt.tenant.service.repo.SysDatabaseSourceRepo;
import com.elitescloud.cloudt.tenant.service.repo.SysDatabaseSourceRepoProc;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysDatabaseSourceServiceImpl
implements SysDatabaseSourceService {
    private static final SysDatabaseSourceConvert CONVERT = SysDatabaseSourceConvert.INSTANCE;
    private final SysDatabaseSourceRepo sysDatabaseSourceRepo;
    private final SysDatabaseSourceRepoProc sysDatabaseSourceRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<SysDatabaseSourceVO> search(SysDatabaseSourceQueryParam param) {
        Page ret = this.sysDatabaseSourceRepo.findAll(this.sysDatabaseSourceRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(SysDatabaseSourceConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    @Override
    @SysCodeProc
    public Optional<SysDatabaseSourceVO> findIdOne(Long id) {
        return this.sysDatabaseSourceRepo.findById(id).map(SysDatabaseSourceConvert.INSTANCE::doToVO);
    }

    @Override
    @Transactional
    public Long createOne(SysDatabaseSourceDO sysDatabaseSourceDO) {
        return ((SysDatabaseSourceDO)this.sysDatabaseSourceRepo.save(sysDatabaseSourceDO)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<SysDatabaseSourceDO> list) {
        return this.sysDatabaseSourceRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(SysDatabaseSourceUpdateParam updateParam) {
        Optional optional = this.sysDatabaseSourceRepo.findById(updateParam.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SysDatabaseSourceDO sourceDo = (SysDatabaseSourceDO)optional.get();
        CONVERT.convertUpdateParm(updateParam, sourceDo);
        this.sysDatabaseSourceRepo.save(sourceDo);
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        this.sysDatabaseSourceRepoProc.updateDeleteFlag(id);
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        this.sysDatabaseSourceRepo.deleteById(id);
    }

    public SysDatabaseSourceServiceImpl(SysDatabaseSourceRepo sysDatabaseSourceRepo, SysDatabaseSourceRepoProc sysDatabaseSourceRepoProc) {
        this.sysDatabaseSourceRepo = sysDatabaseSourceRepo;
        this.sysDatabaseSourceRepoProc = sysDatabaseSourceRepoProc;
    }
}

