package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.service.SysTenantMngService;
import com.elitescloud.cloudt.tenant.service.SysTenantQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * 租户APP管理.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@ResponseBody
@RequestMapping(value = "/sys/sysTenantApp", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "租户App", tags = {"租户App"})
public class SysTenantAppController {

    @Autowired
    private SysTenantMngService tenantMngService;
    @Autowired
    private SysTenantQueryService tenantQueryService;

    @ApiOperation(value = "保存租户的APP")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户ID", required = true, dataType = "int"),
            @ApiImplicitParam(name = "appCodes", value = "应用编码", required = true, dataType = "String", allowMultiple = true),
    })
    @PostMapping(value = "/{tenantId}/save")
    public ApiResult<Long> save(@PathVariable("tenantId") Long tenantId, @RequestBody Set<String> appCodes) {
        return tenantMngService.saveApps(tenantId, appCodes);
    }

    @ApiOperation(value = "获取租户的APP")
    @ApiImplicitParam(name = "tenantId", value = "租户ID", required = true, dataType = "int")
    @GetMapping(value = "/{tenantId}/get")
    public ApiResult<List<IdCodeNameCheckParam>> get(@PathVariable("tenantId") Long tenantId) {
        return tenantQueryService.getApps(tenantId);
    }
}
