package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.boot.common.param.ComSearchParam;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.TenantRpcProvider;
import com.elitescloud.cloudt.tenant.model.vo.TestDemoVO;
import com.elitescloud.cloudt.tenant.model.vo.params.TestDemoSaveVO;
import com.elitescloud.cloudt.tenant.service.TestDemoService;
import com.elitescloud.cloudt.tenant.service.repo.TestDemoRepoProc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 * @ignore
 */
@Api(value = "租户数据测试", tags = {"【调试】租户数据测试"})
@RestController
@RequestMapping(value = "/test/tenant/demo", produces = MediaType.APPLICATION_JSON_VALUE)
public class TestTenantDemoController {

    @Autowired(required = false)
    private TestDemoService demoService;
    @Autowired(required = false)
    private TenantProvider tenantProvider;
    @Autowired(required = false)
    private TenantRpcProvider tenantRpcProvider;
    @Autowired
    private TestDemoRepoProc demoRepoProc;

    @GetMapping(value = "/rpc/allTenant")
    public ApiResult<Object> allTenant() {
        var res = tenantRpcProvider.allTenants();
        return ApiResult.ok(res);
    }

    /**
     * 测试保存数据
     *
     * @param saveVO 保存信息
     * @return 租户ID
     */
    @ApiOperation("测试租户保存数据")
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid TestDemoSaveVO saveVO) {
        return demoService.save(saveVO);
    }

    /**
     * 测试查询所有数据
     *
     * @return 所有数据
     */
    @ApiOperation("测试租户查询所有数据")
    @GetMapping(value = "/queryAll")
    public ApiResult<List<TestDemoVO>> query() {
        return demoService.queryAll();
    }

    /**
     * 获取所有租户
     * @return
     */
    @GetMapping(value = "/allTenant")
    public Object getAllTenant() {
        return tenantProvider.getAllTenant();
    }

    @GetMapping(value = "/groupBy")
    public Object testGroupBy(HttpServletRequest request, ComSearchParam searchParam) {
        return demoRepoProc.queryGroupBy(searchParam);
    }

    /**
     * 测试保存
     *
     * @param username 用户名
     * @param id ID
     * @return ID
     */
    @ApiOperation(value = "测试保存")
    @GetMapping(value = "/testUpsert")
    public Object testUpsert(String username, Long id) {
        return demoService.upsert(username, id);
    }
}
