package com.elitescloud.cloudt.tenant.model.vo.params;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 租户查询参数.
 *
 * @author Kaiser（wang shao）
 * 2022/4/24
 */
@Data
@ApiModel(description = "租户查询参数")
public class ApiTenantQueryParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -135417197188616639L;

    /**
     * 租户名称
     */
    @ApiModelProperty(value = "租户名称，模糊查询")
    private String tenantName;

    /**
     * 租户编码
     */
    @ApiModelProperty(value = "租户编码，精确查询")
    private String tenantCode;
}
