/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cbpl.infinity.client.router.builder.impl;

import com.elitescloud.cbpl.infinity.client.router.builder.RouterParamBuilder;
import com.elitescloud.cbpl.infinity.client.router.service.RouterAuthService;
import com.elitescloud.cbpl.infinity.client.router.vo.RouterAuthVO;
import com.elitescloud.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitescloud.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitescloud.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class GeneralParamBuilder
implements RouterParamBuilder {
    private static final Logger log = LoggerFactory.getLogger(GeneralParamBuilder.class);
    private final RouterAuthService routerAuthService;

    @Override
    public <T, K extends ResponseVO> HttpParam<T, K> routerParamBuilder(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType) {
        RouterAuthVO routerAuth = this.routerAuthService.queryRouterAuth(param);
        HttpParam params = new HttpParam();
        params.setUrl(routerAuth.getUrl());
        params.setHeaders(this.buildHeader(routerAuth, requestBody));
        params.setBody(requestBody);
        if (Optional.ofNullable(resultType).isPresent()) {
            params.setResultType(resultType);
        }
        params.setResponseType(responseType);
        return params;
    }

    public void setAuthorization(RouterAuthVO routerAuth, Map<String, Object> requestBody, HttpHeaders headers) {
        String auth = routerAuth.getUsername() + ":" + routerAuth.getPassword();
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuth);
        headers.set("Authorization", authHeader);
    }

    private HttpHeaders buildHeader(RouterAuthVO routerAuth, Map<String, Object> requestBody) {
        HttpHeaders headers = new HttpHeaders();
        if (routerAuth.getIsAuth().equals("1") && StringUtils.isNotBlank((CharSequence)routerAuth.getUsername()) && StringUtils.isNotBlank((CharSequence)routerAuth.getPassword())) {
            this.setAuthorization(routerAuth, requestBody, headers);
        }
        return headers;
    }

    public GeneralParamBuilder(RouterAuthService routerAuthService) {
        this.routerAuthService = routerAuthService;
    }
}

