/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cbpl.infinity.client.router.service;

import com.elitescloud.cbpl.infinity.client.router.builder.RouterParamBuilder;
import com.elitescloud.cbpl.infinity.client.router.service.RouterClientService;
import com.elitescloud.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitescloud.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitescloud.cbpl.infinity.web.http.param.HttpParam;
import com.elitescloud.cbpl.infinity.web.http.service.HttpClientService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RouterClientServiceImpl
implements RouterClientService {
    private static final Logger log = LoggerFactory.getLogger(RouterClientServiceImpl.class);
    private final RouterParamBuilder routerParamBuilder;
    private final HttpClientService httpClientService;

    @Override
    public <T, K extends ResponseVO> List<T> query(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType) {
        HttpParam<T, K> routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, resultType, responseType);
        return this.httpClientService.query(routerParam, "S");
    }

    @Override
    public <K extends ResponseVO> K send(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<K> responseType) {
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, responseType);
        return (K)this.httpClientService.send(routerParam);
    }

    public RouterClientServiceImpl(RouterParamBuilder routerParamBuilder, HttpClientService httpClientService) {
        this.routerParamBuilder = routerParamBuilder;
        this.httpClientService = httpClientService;
    }
}

