/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.track.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackService;
import com.elitesland.cbpl.tool.es.domain.TrackEvent;
import com.elitesland.cbpl.tool.es.service.ElasticTrackService;
import com.elitesland.cbpl.tool.es.util.ElasticsearchUtil;
import com.elitesland.cbpl.util.ExceptionUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger log = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    private static final String IDX_INFINITY = "infinity_track";
    @Resource
    private TaskExecutor taskExecutor;
    private final ElasticTrackService elasticTrackService;

    @Override
    public void log(HttpServletRequest request, Object param) {
        CompletableFuture.runAsync(() -> {
            String indexName = ElasticsearchUtil.indexNameByDay((String)IDX_INFINITY);
            this.elasticTrackService.addTrackLog(request, indexName, TrackEvent.TRACK_INFINITY.name(), param);
        }, (Executor)this.taskExecutor).whenComplete((resp, ex) -> {
            if (ObjectUtil.isNotNull((Object)ex)) {
                log.error(ExceptionUtil.formatException((Throwable)ex));
            }
        });
    }

    public InfinityTrackServiceImpl(ElasticTrackService elasticTrackService) {
        this.elasticTrackService = elasticTrackService;
    }
}

