package com.elitesland.cbpl.infinity.server.account.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Entity
@Table(name = "infinity_account", uniqueConstraints = {@UniqueConstraint(columnNames = "username")})
@org.hibernate.annotations.Table(appliesTo = "infinity_account", comment = "对外提供接口的认证账号")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class InfinityAccountDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 165434781132588149L;

    @Column()
    @Comment("所属租户")
    private Long belongTenant;

    @Column()
    @Comment("认证账号")
    private String username;

    @Column()
    @Comment("认证密码")
    private String password;

    @Column()
    @Comment("拦截地址：逗号分隔")
    private String interceptUri;
}
