package com.elitesland.cbpl.infinity.server.account.repo;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.account.entity.QInfinityAccountDO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Repository
@RequiredArgsConstructor
public class InfinityAccountRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QInfinityAccountDO Q_INFINITY_ACCOUNT_DO = QInfinityAccountDO.infinityAccountDO;

    public List<InfinityAccountRespVO> queryAccounts(String username) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Q_INFINITY_ACCOUNT_DO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(username)) {
            predicates.add(Q_INFINITY_ACCOUNT_DO.username.eq(username));
        }
        var query = jpaQueryFactory
                .select(Projections.bean(
                        InfinityAccountRespVO.class,
                        Q_INFINITY_ACCOUNT_DO.id,
                        Q_INFINITY_ACCOUNT_DO.username,
                        Q_INFINITY_ACCOUNT_DO.password,
                        Q_INFINITY_ACCOUNT_DO.belongTenant,
                        Q_INFINITY_ACCOUNT_DO.interceptUri
                ))
                .from(Q_INFINITY_ACCOUNT_DO);
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }
}
