package com.elitesland.cbpl.infinity.server.audit.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2021/07/14
 */
@Entity
@Table(name = "infinity_audit")
@org.hibernate.annotations.Table(appliesTo = "infinity_audit", comment = "接口同步审计表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class InfinityAuditDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1710473429036979672L;

    @Column()
    @Comment("组织编码")
    private String buCode;

    @Column()
    @Comment("平台编码：ERP、饿了么、旺店通等")
    private String platformCode;

    @Column()
    @Comment("接口编码")
    private String routerCode;

    @Column()
    @Comment("最后更新时间")
    private String lastUpdateTime;
}
