package com.elitesland.cbpl.infinity.server.platform.repo;

import com.elitesland.cbpl.infinity.server.platform.entity.QInfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.InfinityPlatformParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.InfinityPlatformRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Repository
@RequiredArgsConstructor
public class InfinityPlatformRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QInfinityPlatformDO Q_INFINITY_PLATFORM_DO = QInfinityPlatformDO.infinityPlatformDO;

    /**
     * 查询路由地址
     */
    public List<InfinityPlatformRespVO> queryAuth(InfinityPlatformParamVO param) {
        var query = jpaQueryFactory
                .select(Projections.bean(
                        InfinityPlatformRespVO.class,
                        Q_INFINITY_PLATFORM_DO.id,
                        Q_INFINITY_PLATFORM_DO.buCode,
                        Q_INFINITY_PLATFORM_DO.platformCode,
                        Q_INFINITY_PLATFORM_DO.username,
                        Q_INFINITY_PLATFORM_DO.password,
                        Q_INFINITY_PLATFORM_DO.loginName,
                        Q_INFINITY_PLATFORM_DO.appKey,
                        Q_INFINITY_PLATFORM_DO.appSecret,
                        Q_INFINITY_PLATFORM_DO.remark
                ))
                .from(Q_INFINITY_PLATFORM_DO);

        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(param.getBuCode())) {
            predicates.add(Q_INFINITY_PLATFORM_DO.buCode.eq(param.getBuCode()));
        }
        if (StringUtils.isNotBlank(param.getPlatformCode())) {
            predicates.add(Q_INFINITY_PLATFORM_DO.platformCode.eq(param.getPlatformCode()));
        }
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }
}
