package com.elitesland.cbpl.infinity.server.router.vo.resp;

import com.elitesland.cbpl.infinity.server.router.enums.AuthMethod;
import com.elitesland.cbpl.infinity.server.router.enums.ParseMethod;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Data
public class InfinityRouterRespVO {

    /**
     * 唯一标识
     */
    private Long id;

    /**
     * 认证ID
     */
    private Long authId;

    /**
     * 组织编码
     */
    private String buCode;

    /**
     * 接口编码
     */
    private String routerCode;

    /**
     * 接口名称
     */
    private String routerName;

    /**
     * 认证方式
     */
    @Enumerated(EnumType.STRING)
    private AuthMethod authMethod;

    /**
     * 接口地址
     */
    private String url;

    /**
     * 请求方式
     */
    @Enumerated(EnumType.STRING)
    private RequestMethod requestMethod;

    /**
     * 接口动作：用于标识接口用途
     */
    private String action;

    /**
     * 接口地址解析方式
     */
    @Enumerated(EnumType.STRING)
    private ParseMethod parseMethod;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否使用授权认证
     */
    private String isAuth;
}
