package com.elitesland.cbpl.infinity.web.http.param;

import lombok.Data;
import org.springframework.http.HttpHeaders;

import java.util.Map;

/**
 * 接口请求参数
 *
 * @author eric.hao
 * @since 2021/08/04
 */
@Data
public class HttpParam<T, K> {

    /**
     * 接口地址
     */
    private String url;

    /**
     * 接口请求头
     */
    private HttpHeaders headers;

    /**
     * 接口参数
     */
    private Map<String, Object> body;

    /**
     * 响应值的实体类型
     */
    private Class<K> responseType;

    /**
     * 返回数据结果的实体类型
     */
    private Class<T> resultType;
}
