package com.elitesland.cbpl.infinity.web.http.service;


import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;

import java.util.List;
import java.util.function.Consumer;

/**
 * @author eric.hao
 * @since 2021/08/03
 */
public interface HttpClientService {

    /**
     * 查询接口
     */
    <T, K extends ResponseVO> List<T> query(HttpParam<T, K> param, String successCode);

    /**
     * 写入接口
     */
    default <T, K extends ResponseVO> K send(HttpParam<T, K> param, String bizCode, Consumer<K> callback) {
        K response = send(param);
        response.setBizCode(bizCode);
        callback.accept(response);
        return response;
    }

    <T, K extends ResponseVO> K send(HttpParam<T, K> param);
}
