package com.elitesland.cbpl.infinity.web.http.service;

import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.util.BeanConvertUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import static com.elitesland.cbpl.infinity.web.util.BeanConvertUtil.hashMapToString;
import static org.springframework.http.MediaType.APPLICATION_FORM_URLENCODED;
import static org.springframework.http.MediaType.MULTIPART_FORM_DATA;

/**
 * @author eric.hao
 * @since 2021/08/03
 */
@Slf4j
@Service
public class HttpClientServiceImpl implements HttpClientService {

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public <T, K extends ResponseVO> List<T> query(HttpParam<T, K> param, String successCode) {
        try {
            K response = exchange(param.getUrl(), param.getHeaders(), param.getBody(), param.getResponseType());
            if (ResponseVO.success(response, successCode)) {
                List<Map<String, Object>> entities = response.getData();
                log.trace("[HTTP-REQ] RESULT LIST: {}", entities);
                return BeanConvertUtil.toEntities(entities, param.getResultType());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("[HTTP-REQ] QUERY FAIL. URL({}), PARAMS:({})", param.getUrl(), hashMapToString(param.getBody()));
        return Collections.emptyList();
    }

    @Override
    public <T, K extends ResponseVO> K send(HttpParam<T, K> param) {
        try {
            return exchange(param.getUrl(), param.getHeaders(), param.getBody(), param.getResponseType());
        } catch (IOException e) {
            e.printStackTrace();
        }
        log.info("[HTTP-REQ] PUT FAIL. URL({}), PARAMS:({})", param.getUrl(), hashMapToString(param.getBody()));
        return ResponseVO.error();
    }

    private <T extends ResponseVO> T exchange(String url, HttpHeaders headers, Map<String, Object> body, Class<T> resultType) throws IOException {
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[HTTP-REQ] REQUEST START... ...");
        String params = hashMapToString(body);
        log.info("[HTTP-REQ] URL({}), HEADERS:({}), PARAMS:({})", url, headers.toString(), params);
        String responseStr = "";
//        if (isMultiPartData(headers)) {
//            MultiValueMap<String, Object> multiBody = new LinkedMultiValueMap<>();
//            body.forEach(multiBody::add);
//            responseStr = restTemplate.exchange(url, HttpMethod.POST, new HttpEntity<>(multiBody, headers), String.class).getBody();
//        } else {
//            responseStr = restTemplate.exchange(url, HttpMethod.POST, new HttpEntity<>(body, headers), String.class).getBody();
//        }
        log.info("[HTTP-REQ] responseStr: {}", responseStr);
        T response = StringUtils.isBlank(responseStr) ? ResponseVO.empty() : BeanConvertUtil.toEntity(responseStr, resultType);
        log.info("[HTTP-REQ] FINISHED. STATUS:({}), MSG:({}). ", response.getCode(), response.getMessage());
        LocalDateTime endTime = LocalDateTime.now();
        Duration duration = Duration.between(endTime, startTime);
        log.info("[HTTP-REQ] SPEND TIME: {}", duration.toMillis());
        // TODO add log
        return response;
    }

    private boolean isMultiPartData(HttpHeaders headers) {
        List<MediaType> mediaTypes = Arrays.asList(MULTIPART_FORM_DATA, APPLICATION_FORM_URLENCODED);
        return headers != null && headers.getContentType() != null && mediaTypes.contains(headers.getContentType());
    }
}
