package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author : chun.yan
 * @Date : 2022-06-02
 */
@Data
@ApiModel("产品关联DTO")
public class ItmItemRelevanceDTO implements Serializable {

    private static final long serialVersionUID = 774364731598892327L;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * ITEM_ID
     */
    @ApiModelProperty(value = "ITEM_ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 分类ID
     */
    @ApiModelProperty(value = "分类ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catId;

    /**
     * 关联类型
     */
    @ApiModelProperty(value = "关联类型")
    private String relevanceType;




}
