package com.elitesland.support.provider.item.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-04-06
 */
@Data
public class ItmItemCateDetailsDTO implements Serializable {

    private static final long serialVersionUID = 1826351979206214588L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "父级ID")
    private Long pid;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 科目级别
     */
    @ApiModelProperty(value = "科目级别")
    private Integer level;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 上级品类路径名称
     */
    @ApiModelProperty(value = "上级品类路径名称（父级>子级）")
    private String itemCatePathName;

    /**
     * 是否基础类目（0：不是，1：是）
     */
    @ApiModelProperty(value = "是否基础类目（0：不是，1：是）")
    private Integer itemCateIsBasic;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;

    /**
     * 品类描述
     */
    @ApiModelProperty(value = "品类描述")
    private String itemCateDesc;

    /**
     * es1
     */
    @ApiModelProperty("es1")
    private String es1;

    /**
     * es2
     */
    @ApiModelProperty("es2")
    private String es2;

    /**
     * es3
     */
    @ApiModelProperty("es3")
    private String es3;
    /**
     * es4
     */
    @ApiModelProperty("es4")
    private String es4;


    /**
     * es5
     */
    @ApiModelProperty("es5")
    private String es5;

    /**
     * es6
     */
    @ApiModelProperty("es6")
    private String es6;

    /**
     * es7
     */
    @ApiModelProperty("es7")
    private String es7;


    /**
     * es8
     */
    @ApiModelProperty("es8")
    private String es8;


    /**
     * es9
     */
    @ApiModelProperty("es9")
    private String es9;


    /**
     * es10
     */
    @ApiModelProperty("es10")
    private String es10;
}
