package com.elitesland.support.provider.org.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/10
 */
@Data
@ApiModel("OU公司新增参数")
public class OrgOuRpcSaveParam implements Serializable {

    private static final long serialVersionUID = -8851674597586176829L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private String id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "公司所属组织编号")
    private Long pid;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织buId")
    private Long buId;

    /**
     * 公司编号
     */
    @ApiModelProperty(value = "公司编号")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 上级组织名称
     */
    @ApiModelProperty(value = "上级组织名称")
    private String pname;

    /**
     * 是否新建组织
     */
    @ApiModelProperty(value = "是否新建组织")
    private boolean selectedCreateOu;

    /**
     * 公司简称
     */
    @ApiModelProperty(value = "公司简称")
    private String ouAbbr;

    /**
     * 公司类型
     */
    @ApiModelProperty(value = "公司类型")
    private String ouType;

    /**
     * 公司归类
     */
    @ApiModelProperty(value = "公司归类")
    private String ouType2;

    /**
     * 公司状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty(value = "公司状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String ouStatus;

    /**
     * 法人公司ID
     */
    @ApiModelProperty(value = "法人公司ID")
    private Long legalOuId;

    /**
     * 法人公司名称
     */
    @ApiModelProperty(value = "法人公司名称")
    private String legalOuName;

    /**
     * 排序号 用于相同层级的排序
     */
    @ApiModelProperty(value = "排序号 用于相同层级的排序")
    private Integer sortNo;

    /**
     * 法人代表
     */
    @ApiModelProperty(value = "法人代表")
    private String reprName;

    /**
     * 分销渠道
     */
    @ApiModelProperty(value = "分销渠道")
    private List<String> saleChannels;

    /**
     * 工商登记号
     */
    @ApiModelProperty(value = "统一信用代码（原 工商登记号）")
    private String icRegisterNo;

    /**
     * 本位币
     */
    @ApiModelProperty(value = "本位币")
    private String ouCurr;

    /**
     * 纳税人类型
     */
    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;

    /**
     * 纳税人识别号
     */
    @ApiModelProperty(value = "纳税人识别号")
    private String taxerCode;

    /**
     * 税务登记号
     */
    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    /**
     * 开票电话
     */
    @ApiModelProperty(value = "开票电话")
    private String invTel;

    /**
     * 区域
     */
    @ApiModelProperty(value = "区域")
    private String region;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invType;

    /**
     * 开户银行
     */
    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    /**
     * 银行账号
     */
    @ApiModelProperty(value = "银行账号")
    private String invBankAcc;

    /**
     * 开票抬头
     */
    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    /**
     * 开票联系人
     */
    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    /**
     * 开票联系人电话
     */
    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    /**
     * 开票地址
     */
    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    /**
     * 类别码
     */
    @ApiModelProperty(value = "类别码")
    private String cat;

    /**
     * 类别码2
     */
    @ApiModelProperty(value = "类别码2")
    private String cat2;

    /**
     * 类别码3
     */
    @ApiModelProperty(value = "类别码3")
    private String cat3;

    /**
     * 类别码4
     */
    @ApiModelProperty(value = "类别码4")
    private String cat4;

    /**
     * 类别码5
     */
    @ApiModelProperty(value = "类别码5")
    private String cat5;

    /**
     * 类别码6
     */
    @ApiModelProperty(value = "类别码6")
    private String cat6;

    /**
     * 类别码7
     */
    @ApiModelProperty(value = "类别码7")
    private String cat7;

    /**
     * 类别码8
     */
    @ApiModelProperty(value = "类别码8")
    private String cat8;

    /**
     * 类别码9
     */
    @ApiModelProperty(value = "类别码9")
    private String cat9;

    /**
     * 类别码10
     */
    @ApiModelProperty(value = "类别码10")
    private String cat10;

    /**
     * 类别码11
     */
    @ApiModelProperty(value = "类别码11")
    private String cat11;

    /**
     * 类别码12
     */
    @ApiModelProperty(value = "类别码12")
    private String cat12;

    /**
     * 类别码13
     */
    @ApiModelProperty(value = "类别码13")
    private String cat13;

    /**
     * 类别码14
     */
    @ApiModelProperty(value = "类别码14")
    private String cat14;

    /**
     * 类别码15
     */
    @ApiModelProperty(value = "类别码15")
    private String cat15;

    /**
     * 类别码16
     */
    @ApiModelProperty(value = "类别码16")
    private String cat16;

    /**
     * 类别码17
     */
    @ApiModelProperty(value = "类别码17")
    private String cat17;

    /**
     * 类别码18
     */
    @ApiModelProperty(value = "类别码18")
    private String cat18;

    /**
     * 类别码19
     */
    @ApiModelProperty(value = "类别码19")
    private String cat19;

    /**
     * 类别码20
     */
    @ApiModelProperty(value = "类别码20")
    private String cat20;

    /**
     * 地址簿参数
     */
    @ApiModelProperty(value = "地址簿参数")
    private OrgAddrRpcSaveParam orgAddrSaveParam;

    /**
     * 核算编码
     */
    @ApiModelProperty(value = "核算编码")
    private String externalCode;

    /**
     * 外部系统类型
     */
    @ApiModelProperty(value = "外部系统类型名称")
    private String outerSysType;

    @ApiModelProperty(value = "地址号，不为空则不新增地址簿信息")
    private Long addrNo;

}
