/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.base.param;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.param.OrderQueryParam;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.jpa.impl.JPAQuery;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ApiModel(value="\u53ef\u6392\u5e8f\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61")
public abstract class AbstractOrderQueryParam
extends OrderQueryParam {
    private static final long serialVersionUID = 57714391204790143L;

    @JsonIgnore
    public PageRequest getPageRequest() {
        ArrayList orderBys = CollectionUtils.isEmpty((Collection)this.getOrders()) ? new ArrayList() : this.getOrders().stream().filter(t -> StringUtils.hasText((String)t.getColumn())).map(o -> new Sort.Order(o.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC, o.getColumn())).collect(Collectors.toList());
        return PageRequest.of((int)this.getCurrent(), (int)this.getSize(), (Sort)Sort.by(orderBys));
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query, EntityPathBase<?> entityPathBase) {
        PageRequest pageRequest = this.getPageRequest();
        PathBuilder orderbyExpr = new PathBuilder(entityPathBase.getClass(), entityPathBase.getMetadata(), PathBuilderValidator.FIELDS);
        pageRequest.getSort().forEach(s -> query.orderBy(new OrderSpecifier(s.isAscending() ? Order.ASC : Order.DESC, (Expression)orderbyExpr.get(s.getProperty()))));
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query) {
        PageRequest pageRequest = this.getPageRequest();
        pageRequest.getSort().forEach(s -> {
            String[] sects = s.getProperty().split("\\.");
            if (sects.length <= 1) {
                throw new BusinessException(ApiCode.PARAMETER_PARSE_EXCEPTION, "\u6392\u5e8f\u5b57\u6bb5\u9700\u8981\u6307\u5b9a\u6240\u5c5ehql\u7684\u5b9e\u4f53\u5bf9\u8c61\uff0c\u5bf9\u8c61\u540d\u79f0.\u5b57\u6bb5\u540d\u79f0");
            }
            PathBuilder orderbyExpr = new PathBuilder(Object.class, sects[0]);
            query.orderBy(new OrderSpecifier(s.isAscending() ? Order.ASC : Order.DESC, (Expression)orderbyExpr.get(sects[1])));
        });
    }

    @JsonIgnore
    public void setPaging(JPAQuery<?> query) {
        query.offset((long)this.getCurrent().intValue() * (long)this.getSize().intValue());
        query.limit((long)this.getSize().intValue());
    }

    public String toString() {
        return "AbstractOrderQueryParam()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOrderQueryParam)) {
            return false;
        }
        AbstractOrderQueryParam other = (AbstractOrderQueryParam)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractOrderQueryParam;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

