/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.common;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import org.springframework.util.StringUtils;

public class CloudtAppHolder {
    private static String appCode = "unknown";
    private static String appName = "\u7cfb\u7edf";
    private static final String serverInstance;
    private static final String serverIp;

    public static String getAppCode() {
        return appCode;
    }

    public static void setAppCode(String appCode) {
        if (!StringUtils.hasText((String)appCode)) {
            return;
        }
        CloudtAppHolder.appCode = appCode;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        if (!StringUtils.hasText((String)appName)) {
            return;
        }
        CloudtAppHolder.appName = appName;
    }

    public static String getServerInstance() {
        return CloudtAppHolder.getAppCode() + "." + serverInstance;
    }

    public static String getServerIp() {
        return serverIp;
    }

    private static InetAddress getCurrentServerAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress;
                }
            }
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            throw new IllegalStateException("\u89e3\u6790IP\u5f02\u5e38", e);
        }
    }

    static {
        serverIp = CloudtAppHolder.getCurrentServerAddress().getHostAddress();
        serverInstance = serverIp + "." + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
    }
}

