/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.common;

import cn.hutool.core.collection.IteratorEnumeration;
import cn.hutool.core.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class CloudtRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtRequestWrapper.class);
    private final MultiValueMap<String, String> headers = new LinkedMultiValueMap(8);
    private final byte[] body;

    public CloudtRequestWrapper(HttpServletRequest request) {
        super(request);
        this.body = this.obtainBody((ServletRequest)request);
    }

    public void addHeader(String name, String value) {
        this.headers.add((Object)name, (Object)value);
    }

    public String getBodyString() {
        if (ArrayUtil.isEmpty((byte[])this.body)) {
            return null;
        }
        return new String(this.body);
    }

    public long getDateHeader(String name) {
        String value = (String)this.headers.getFirst((Object)name);
        if (StringUtils.hasText((String)value)) {
            Date date = new Date(Long.parseLong(value));
            return date.getTime();
        }
        return super.getDateHeader(name);
    }

    public String getHeader(String name) {
        String value = (String)this.headers.getFirst((Object)name);
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        List values = (List)this.headers.get((Object)name);
        if (!CollectionUtils.isEmpty((Collection)values)) {
            ArrayList<String> result = new ArrayList<String>(values);
            Enumeration headersOriginal = super.getHeaders(name);
            while (headersOriginal.hasMoreElements()) {
                result.add((String)headersOriginal.nextElement());
            }
            return new IteratorEnumeration(result.iterator());
        }
        return super.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        if (!this.headers.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(this.headers.keySet());
            Enumeration headersOriginal = super.getHeaderNames();
            while (headersOriginal.hasMoreElements()) {
                result.add((String)headersOriginal.nextElement());
            }
            return new IteratorEnumeration(result.iterator());
        }
        return super.getHeaderNames();
    }

    public int getIntHeader(String name) {
        String value = (String)this.headers.getFirst((Object)name);
        if (StringUtils.hasText((String)value)) {
            return Integer.parseInt(value);
        }
        return super.getIntHeader(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return inputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private byte[] obtainBody(ServletRequest request) {
        try {
            return request.getInputStream().readAllBytes();
        }
        catch (Exception e) {
            LOG.error("read body exception\uff1a", (Throwable)e);
            return new byte[0];
        }
    }
}

