/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.condition.support;

import com.elitescloud.cloudt.common.condition.ConditionalOnTenant;
import com.elitescloud.cloudt.common.condition.support.AbstractCondition;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnTenantCondition
extends AbstractCondition {
    private String CONFIG_PREFIX = "elitesland.tenant.client";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        TenantIsolateStrategy[] strategies;
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnTenant.class.getName());
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        if (this.existsAttribute(attributes, "enabled", "true")) {
            boolean enabled;
            boolean bl = enabled = this.isPresent("com.elitescloud.cloudt.tenant.TenantClient", null) && this.existsEnvironment(context, this.CONFIG_PREFIX + ".enabled", "true", "true");
            if (!enabled) {
                return ConditionOutcome.noMatch((String)"\u672a\u542f\u7528\u79df\u6237");
            }
        }
        if ((strategies = (TenantIsolateStrategy[])attributes.getOrDefault("isolateStrategy", new TenantIsolateStrategy[0])).length > 0) {
            String strategy = context.getEnvironment().getProperty(this.CONFIG_PREFIX + ".isolate-strategy", TenantIsolateStrategy.NONE.name());
            boolean matched = false;
            for (TenantIsolateStrategy tenantIsolateStrategy : strategies) {
                if (!tenantIsolateStrategy.name().equals(strategy)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return ConditionOutcome.noMatch((String)"\u79df\u6237\u7684\u9694\u79bb\u7b56\u7565\u4e0d\u6ee1\u8db3");
            }
        }
        return ConditionOutcome.match();
    }
}

