/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbMetadataService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DbJooqMysqlMetadataServiceImpl
implements DbMetadataService {
    private static final Logger log = LoggerFactory.getLogger(DbJooqMysqlMetadataServiceImpl.class);
    private final DSLContext dsl;

    public DbJooqMysqlMetadataServiceImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public List<DbFieldDo> getDbTableFieldDo(String schema, String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            return new ArrayList<DbFieldDo>();
        }
        Result records = this.dsl.select((SelectField)DSL.field((String)"TABLE_CATALOG"), (SelectField)DSL.field((String)"TABLE_SCHEMA"), (SelectField)DSL.field((String)"TABLE_NAME"), (SelectField)DSL.field((String)"COLUMN_NAME"), (SelectField)DSL.field((String)"COLUMN_TYPE"), (SelectField)DSL.field((String)"CHARACTER_MAXIMUM_LENGTH"), (SelectField)DSL.field((String)"ORDINAL_POSITION"), (SelectField)DSL.field((String)"NUMERIC_PRECISION"), (SelectField)DSL.field((String)"NUMERIC_SCALE"), (SelectField)DSL.field((String)"IS_NULLABLE"), (SelectField)DSL.field((String)"COLUMN_DEFAULT"), (SelectField)DSL.field((String)"COLUMN_KEY"), (SelectField)DSL.field((String)"EXTRA"), (SelectField)DSL.field((String)"COLUMN_COMMENT")).from((TableLike)DSL.table((String)"INFORMATION_SCHEMA.COLUMNS")).where(DSL.field((String)"TABLE_NAME").eq((Object)tableName)).fetch();
        if (records == null || records.size() == 0) {
            return null;
        }
        List<DbFieldDo> dbFields = records.stream().map(this::mapRecordToDbFieldDo).collect(Collectors.toList());
        return dbFields;
    }

    @Override
    public List<DbTableDo> getDbTableDo(String schema, String tableName) {
        if (schema == null) {
            schema = this.getCurrentSchema();
            log.info("schema is null,use current schema:{}", (Object)schema);
        }
        SelectJoinStep select = this.dsl.select((SelectField)DSL.field((String)"TABLE_CATALOG"), (SelectField)DSL.field((String)"TABLE_SCHEMA"), (SelectField)DSL.field((String)"TABLE_NAME"), (SelectField)DSL.field((String)"TABLE_TYPE"), (SelectField)DSL.field((String)"ENGINE"), (SelectField)DSL.field((String)"VERSION"), (SelectField)DSL.field((String)"ROW_FORMAT"), (SelectField)DSL.field((String)"TABLE_ROWS"), (SelectField)DSL.field((String)"AVG_ROW_LENGTH"), (SelectField)DSL.field((String)"DATA_LENGTH"), (SelectField)DSL.field((String)"MAX_DATA_LENGTH"), (SelectField)DSL.field((String)"INDEX_LENGTH"), (SelectField)DSL.field((String)"DATA_FREE"), (SelectField)DSL.field((String)"AUTO_INCREMENT"), (SelectField)DSL.field((String)"CREATE_TIME"), (SelectField)DSL.field((String)"UPDATE_TIME"), (SelectField)DSL.field((String)"CHECK_TIME"), (SelectField)DSL.field((String)"TABLE_COLLATION"), (SelectField)DSL.field((String)"CHECKSUM"), (SelectField)DSL.field((String)"CREATE_OPTIONS"), (SelectField)DSL.field((String)"TABLE_COMMENT")).from("INFORMATION_SCHEMA.tables");
        Result tables = null;
        tables = tableName != null ? select.where(DSL.field((String)"TABLE_NAME").eq((Object)tableName)).and(DSL.field((String)"TABLE_SCHEMA").eq((Object)schema)).fetch() : select.where(DSL.field((String)"TABLE_SCHEMA").eq((Object)schema)).fetch();
        ArrayList<DbTableDo> dbTableDos = new ArrayList<DbTableDo>();
        for (Record record : tables) {
            DbTableDo dbTable = new DbTableDo();
            dbTable.setTableCatalog((String)record.get("TABLE_CATALOG", String.class));
            dbTable.setTableSchema((String)record.get("TABLE_SCHEMA", String.class));
            dbTable.setTableName((String)record.get("TABLE_NAME", String.class));
            dbTable.setTableType((String)record.get("TABLE_TYPE", String.class));
            dbTable.setEngine((String)record.get("ENGINE", String.class));
            dbTable.setVersion((Integer)record.get("VERSION", Integer.class));
            dbTable.setRowFormat((String)record.get("ROW_FORMAT", String.class));
            dbTable.setTableRows((Long)record.get("TABLE_ROWS", Long.class));
            dbTable.setAvgRowLength((Long)record.get("AVG_ROW_LENGTH", Long.class));
            dbTable.setDataLength((Long)record.get("DATA_LENGTH", Long.class));
            dbTable.setMaxDataLength((Long)record.get("MAX_DATA_LENGTH", Long.class));
            dbTable.setIndexLength((Long)record.get("INDEX_LENGTH", Long.class));
            dbTable.setDataFree((Long)record.get("DATA_FREE", Long.class));
            dbTable.setAutoIncrement((Long)record.get("AUTO_INCREMENT", Long.class));
            Timestamp createTimeTimestamp = (Timestamp)record.get("CREATE_TIME", Timestamp.class);
            dbTable.setCreateTimeTable(createTimeTimestamp != null ? createTimeTimestamp.toLocalDateTime() : null);
            Timestamp updateTimeTimestamp = (Timestamp)record.get("UPDATE_TIME", Timestamp.class);
            dbTable.setUpdateTimeTable(updateTimeTimestamp != null ? updateTimeTimestamp.toLocalDateTime() : null);
            Timestamp checkTimeTimestamp = (Timestamp)record.get("CHECK_TIME", Timestamp.class);
            dbTable.setCheckTimeTable(checkTimeTimestamp != null ? checkTimeTimestamp.toLocalDateTime() : null);
            dbTable.setTableCollation((String)record.get("TABLE_COLLATION", String.class));
            dbTable.setChecksum((Long)record.get("CHECKSUM", Long.class));
            dbTable.setCreateOptions((String)record.get("CREATE_OPTIONS", String.class));
            dbTable.setTableComment((String)record.get("TABLE_COMMENT", String.class));
            dbTableDos.add(dbTable);
        }
        return dbTableDos;
    }

    @Override
    public String getCurrentSchema() {
        Result result = this.dsl.select((SelectField)DSL.field((String)"DATABASE()", String.class)).fetch();
        if (result.isNotEmpty()) {
            return (String)((Record1)result.get(0)).value1();
        }
        return null;
    }

    @Override
    public List<String> getAllSchemas() {
        return this.dsl.select(new SelectFieldOrAsterisk[0]).from("information_schema.SCHEMATA").fetch().stream().map(record -> (String)record.get("SCHEMA_NAME", String.class)).collect(Collectors.toList());
    }

    private DbFieldDo mapRecordToDbFieldDo(Record record) {
        DbFieldDo field = new DbFieldDo();
        field.setTableCatalog((String)record.get("TABLE_CATALOG", String.class));
        field.setDbTableName((String)record.get("TABLE_NAME", String.class));
        field.setTableSchema((String)record.get("TABLE_SCHEMA", String.class));
        field.setDbFieldName((String)record.get("COLUMN_NAME", String.class));
        field.setDbFieldType((String)record.get("COLUMN_TYPE", String.class));
        field.setDbOrder((Integer)record.get("ORDINAL_POSITION", Integer.class));
        field.setDbFieldLength((Integer)record.get("CHARACTER_MAXIMUM_LENGTH", Integer.class));
        field.setDbFieldPrecision((Integer)record.get("NUMERIC_PRECISION", Integer.class));
        field.setDbFieldScale((Integer)record.get("NUMERIC_SCALE", Integer.class));
        field.setDbFieldNullable("YES".equals(record.get("IS_NULLABLE", String.class)));
        field.setDbFieldDefaultValue((String)record.get("COLUMN_DEFAULT", String.class));
        field.setDbFieldPrimaryKey("PRI".equals(record.get("COLUMN_KEY", String.class)));
        field.setDbFieldUnique("UNI".equals(record.get("COLUMN_KEY", String.class)));
        field.setDbFieldIndex("MUL".equals(record.get("COLUMN_KEY", String.class)));
        field.setDbFieldAutoIncrement("auto_increment".equals(record.get("EXTRA", String.class)));
        field.setDbFieldDescription((String)record.get("COLUMN_COMMENT", String.class));
        return field;
    }

    public static class DbFieldConstants {
        public static final String FROM_TABLE_NAME = "INFORMATION_SCHEMA.COLUMNS";
        public static final String FIELD_TABLE_NAME = "TABLE_NAME";
        public static final String FIELD_COLUMN_NAME = "COLUMN_NAME";
        public static final String FIELD_DATA_TYPE = "COLUMN_TYPE";
        public static final String ORDINAL_POSITION = "ORDINAL_POSITION";
        public static final String FIELD_CHARACTER_MAXIMUM_LENGTH = "CHARACTER_MAXIMUM_LENGTH";
        public static final String FIELD_NUMERIC_PRECISION = "NUMERIC_PRECISION";
        public static final String FIELD_NUMERIC_SCALE = "NUMERIC_SCALE";
        public static final String FIELD_IS_NULLABLE = "IS_NULLABLE";
        public static final String FIELD_COLUMN_DEFAULT = "COLUMN_DEFAULT";
        public static final String FIELD_COLUMN_KEY = "COLUMN_KEY";
        public static final String FIELD_EXTRA = "EXTRA";
        public static final String FIELD_COLUMN_COMMENT = "COLUMN_COMMENT";
        public static final String FIELD_TABLE_SCHEMA = "TABLE_SCHEMA";
        public static final String FIELD_TABLE_CATALOG = "TABLE_CATALOG";
    }

    public static class DatabaseConstants {
        public static final String FROM_TABLE_NAME = "INFORMATION_SCHEMA.tables";
        public static final String TABLE_CATALOG = "TABLE_CATALOG";
        public static final String TABLE_SCHEMA = "TABLE_SCHEMA";
        public static final String TABLE_NAME = "TABLE_NAME";
        public static final String TABLE_TYPE = "TABLE_TYPE";
        public static final String ENGINE = "ENGINE";
        public static final String VERSION = "VERSION";
        public static final String ROW_FORMAT = "ROW_FORMAT";
        public static final String TABLE_ROWS = "TABLE_ROWS";
        public static final String AVG_ROW_LENGTH = "AVG_ROW_LENGTH";
        public static final String DATA_LENGTH = "DATA_LENGTH";
        public static final String MAX_DATA_LENGTH = "MAX_DATA_LENGTH";
        public static final String INDEX_LENGTH = "INDEX_LENGTH";
        public static final String DATA_FREE = "DATA_FREE";
        public static final String AUTO_INCREMENT = "AUTO_INCREMENT";
        public static final String CREATE_TIME = "CREATE_TIME";
        public static final String UPDATE_TIME = "UPDATE_TIME";
        public static final String CHECK_TIME = "CHECK_TIME";
        public static final String TABLE_COLLATION = "TABLE_COLLATION";
        public static final String CHECKSUM = "CHECKSUM";
        public static final String CREATE_OPTIONS = "CREATE_OPTIONS";
        public static final String TABLE_COMMENT = "TABLE_COMMENT";
    }
}

