/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import cn.hutool.core.bean.BeanException;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.DbModelConvert;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbFieldVo;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbTableVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DbFieldRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DbTableRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbFieldRelationService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbFieldService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbTableService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DbTableServiceImpl
implements DbTableService {
    private final DbTableRepository dbTableRepository;
    private final DbFieldService dbFieldService;
    private final DbFieldRelationService dbFieldRelationService;
    private final DbFieldRepository dbFieldRepository;
    private final DbDataSourceMetadataService dbDataSourceMetadataService;

    public DbTableServiceImpl(DbTableRepository dbTableRepository, DbFieldService dbFieldService, DbFieldRelationService dbFieldRelationService, DbFieldRepository dbFieldRepository, DbDataSourceMetadataService dbDataSourceMetadataService) {
        this.dbTableRepository = dbTableRepository;
        this.dbFieldService = dbFieldService;
        this.dbFieldRelationService = dbFieldRelationService;
        this.dbFieldRepository = dbFieldRepository;
        this.dbDataSourceMetadataService = dbDataSourceMetadataService;
    }

    @Override
    public DbTableVo findByTableName(String TableName) {
        QDbTableDo QDO = QDbTableDo.dbTableDo;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)QDO.tableName).eq(arg_0), (Object)TableName).getPredicate();
        DbTableDo dbTable = (DbTableDo)((Object)this.dbTableRepository.findOne(predicate).orElseThrow(() -> new BeanException(TableName + "\u4e0d\u5b58\u5728")));
        DbTableVo dbTableVo = DbModelConvert.INSTANCE.dbTableDoToVo(dbTable);
        List<DbFieldVo> dbFieldVos = this.dbFieldService.findByTableName(TableName);
        dbTableVo.setDbFieldVos(dbFieldVos);
        return dbTableVo;
    }

    @Override
    public List<DbTableDo> findAll() {
        return this.dbTableRepository.findAll();
    }

    @Override
    public DbTableDo findById(Long id) {
        return this.dbTableRepository.findById(id).orElse(null);
    }

    @Override
    public DbTableDo save(DbTableDo dbTable) {
        return (DbTableDo)((Object)this.dbTableRepository.save((Object)dbTable));
    }

    @Override
    public void delete(Long id) {
        this.dbTableRepository.deleteById(id);
    }

    @Override
    @Transactional
    public ApiResult<String> storeTablesAndFieldsMetadata(DbTableParam dbTableParam) {
        Table table = this.dbDataSourceMetadataService.getTableMeta(dbTableParam.getCatalog(), dbTableParam.getSchema(), dbTableParam.getTableName());
        DbTableDo dbTableDo = new DbTableDo();
        dbTableDo.hutoolTableToDo(table);
        ArrayList<DbFieldDo> DbFieldDos = new ArrayList<DbFieldDo>();
        for (Column column : table.getColumns()) {
            DbFieldDo dbFieldDo = new DbFieldDo();
            dbFieldDo.hutoolColumnToDo(column);
            dbFieldDo.setTableSchema(dbTableDo.getTableSchema());
            dbFieldDo.setTableCatalog(dbTableDo.getTableCatalog());
            DbFieldDos.add(dbFieldDo);
        }
        this.dbTableRepository.deleteByTableNameAndTableSchema(dbTableDo.getTableName(), dbTableDo.getTableSchema());
        this.dbTableRepository.save((Object)dbTableDo);
        this.dbFieldRepository.deleteByDbTableNameAndTableSchema(dbTableDo.getTableName(), dbTableDo.getTableSchema());
        this.dbFieldRepository.saveAll(DbFieldDos);
        return ApiResult.ok();
    }
}

