/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicExportParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportFailures;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportResult;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbAuditFieldService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbTableService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoApiService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicUtil;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl.DynamicBoFieldDefinitionServiceImpl;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetStep;
import org.jooq.InsertValuesStepN;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateQuery;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DynamicBoApiServiceImpl
implements DynamicBoApiService {
    private static final Logger log = LoggerFactory.getLogger(DynamicBoApiServiceImpl.class);
    public static final String TENANT_ID = "tenant_id";
    public static final String ID = "id";
    private final DSLContext dsl;
    private final DbTableService dbTableService;
    private final DynamicBoFieldDefinitionServiceImpl boFieldDefinitionService;
    private final DbAuditFieldService dbAuditFieldService;
    private final DynamicBoModelService boModelService;

    public DynamicBoApiServiceImpl(DSLContext dsl, DbTableService dbTableService, DynamicBoFieldDefinitionServiceImpl boFieldDefinitionService, DbAuditFieldService dbAuditFieldService, DynamicBoModelService boModelService) {
        this.dsl = dsl;
        this.dbTableService = dbTableService;
        this.boFieldDefinitionService = boFieldDefinitionService;
        this.dbAuditFieldService = dbAuditFieldService;
        this.boModelService = boModelService;
    }

    @Override
    public ApiResult<Object> insert(String boModelCode, Map<String, Object> entityData) {
        try {
            DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
            String tableName = boModelDo.getDatabaseTableName();
            List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = boModelDo.getDynamicBoFieldDefinitionDoList();
            Map<String, DynamicBoFieldDefinitionDO> fieldDefinitionMap = this.buildFieldDefinitionMap(boFieldDefinitionDoList);
            DynamicBoApiServiceImpl.boFiledCheck(fieldDefinitionMap, entityData);
            Table table = DSL.table((Name)DSL.name((String)tableName));
            ArrayList fields = new ArrayList();
            ArrayList values = new ArrayList();
            this.dbAuditFieldService.fillInsertAuditFields(entityData);
            entityData.forEach((key, value) -> {
                DynamicBoFieldDefinitionDO dynamicBoFieldDefinitionDO = (DynamicBoFieldDefinitionDO)((Object)((Object)fieldDefinitionMap.get(key)));
                if (dynamicBoFieldDefinitionDO != null) {
                    Field<?> jooqField = DynamicUtil.getJooqField(dynamicBoFieldDefinitionDO);
                    fields.add(jooqField);
                    values.add(DynamicUtil.transformValue(value, dynamicBoFieldDefinitionDO));
                } else {
                    Field jooqField = DSL.field((Name)DSL.name((String)key));
                    fields.add(jooqField);
                    values.add(value);
                }
            });
            InsertValuesStepN insertStep = this.dsl.insertInto(table).columns(fields).values(values);
            insertStep.execute();
            return ApiResult.ok((Object)entityData.get(ID));
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return ApiResult.fail((String)"\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public ApiResult<Integer> update(String boModelCode, Long id, Map<String, Object> entityData) {
        if (boModelCode == null || id == null || entityData == null || entityData.isEmpty()) {
            return ApiResult.fail((String)"Invalid input parameters");
        }
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        if (boModelDo == null) {
            return ApiResult.fail((String)("BO Model not found for code: " + boModelCode));
        }
        String tableName = boModelDo.getDatabaseTableName();
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionByBoModelCodeDos(boModelCode);
        if (boFieldDefinitionDoList == null || boFieldDefinitionDoList.isEmpty()) {
            return ApiResult.fail((String)("Field definitions not found for BO Model code: " + boModelCode));
        }
        Map<String, DynamicBoFieldDefinitionDO> fieldDefinitionMap = this.buildFieldDefinitionMap(boFieldDefinitionDoList);
        DynamicBoApiServiceImpl.boFiledCheck(fieldDefinitionMap, entityData);
        this.dbAuditFieldService.fillUpdateAuditFields(entityData);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        UpdateQuery updateQuery = this.dsl.updateQuery(table);
        entityData.forEach((key, value) -> {
            DynamicBoFieldDefinitionDO dynamicBoFieldDefinitionDO = (DynamicBoFieldDefinitionDO)((Object)((Object)fieldDefinitionMap.get(key)));
            if (dynamicBoFieldDefinitionDO != null) {
                Field<?> jooqField = DynamicUtil.getJooqField(dynamicBoFieldDefinitionDO);
                updateQuery.addValue(jooqField, DynamicUtil.transformValue(value, dynamicBoFieldDefinitionDO));
            } else {
                Field field = DSL.field((Name)DSL.name((String)key), Object.class);
                updateQuery.addValue(field, value);
            }
        });
        Field idField = DSL.field((Name)DSL.name((String)ID), Long.class);
        Condition condition = idField.eq((Object)id);
        condition = this.setTenantIdCondition(condition);
        updateQuery.addConditions(condition);
        try {
            int rowsUpdated = updateQuery.execute();
            return ApiResult.ok((Object)rowsUpdated);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("Database update failed: " + e.getMessage()));
        }
    }

    @Override
    @Transactional
    public ApiResult<Integer> updateBatch(String boModelCode, Map<Long, Map<String, Object>> entityDataMap) {
        entityDataMap.forEach((key, value) -> this.update(boModelCode, (Long)key, (Map<String, Object>)value));
        return ApiResult.ok((Object)entityDataMap.size());
    }

    @Override
    public ApiResult<Page<?>> queryPage(String boModelCode, DynamicFieldQueryParam queryParam) {
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        String tableName = boModelDo.getDatabaseTableName();
        Table table = DSL.table((Name)DSL.name((String)tableName));
        SelectJoinStep baseQuery = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)table);
        Condition condition = DynamicUtil.getDynamicFieldQueryParamCondition(queryParam);
        condition = this.setTenantIdCondition(condition);
        SelectConditionStep conditionalQuery = baseQuery.where(condition);
        SortField[] sortFields = (SortField[])queryParam.getOrders().stream().map(order -> {
            Field orderField = DSL.field((Name)DSL.name((String)order.getColumn()), Object.class);
            return order.isAsc() ? orderField.asc() : orderField.desc();
        }).toArray(SortField[]::new);
        conditionalQuery.orderBy((OrderField[])sortFields);
        int offset = queryParam.getCurrent() * queryParam.getSize();
        Result result = conditionalQuery.limit((Number)queryParam.getSize()).offset(offset).fetch();
        int total = (Integer)this.dsl.selectCount().from((TableLike)table).where(condition).fetchOne(0, Integer.TYPE);
        PageImpl pageResult = new PageImpl(result.intoMaps(), (Pageable)PageRequest.of((int)queryParam.getCurrent(), (int)queryParam.getSize()), (long)total);
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<Map> getById(String boModelCode, Long id) {
        try {
            DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
            String tableName = boModelDo.getDatabaseTableName();
            Table table = DSL.table((Name)DSL.name((String)tableName));
            Condition condition = DSL.field((Name)DSL.name((String)ID)).eq((Object)id);
            condition = this.setTenantIdCondition(condition);
            Record record = this.dsl.selectFrom(table).where(condition).fetchOne();
            if (record == null) {
                return ApiResult.fail((String)"\u672a\u627e\u5230\u6570\u636e");
            }
            Map map = record.intoMap();
            return ApiResult.ok((Object)map);
        }
        catch (Exception e) {
            log.error("\u52a8\u6001\u67e5\u8be2\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u52a8\u6001\u67e5\u8be2\u5f02\u5e38 data by ID: " + e.getMessage()));
        }
    }

    @Override
    public void dynamicExport(String boModelCode, DynamicExportParam dynamicExportParam, HttpServletResponse response) throws IOException {
        if (dynamicExportParam == null || dynamicExportParam.getFieldMap() == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        String tableName = boModelDo.getDatabaseTableName();
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        dynamicExportParam.getFieldMap().forEach((englishName, chineseName) -> {
            ArrayList<String> headerColumn = new ArrayList<String>();
            headerColumn.add((String)englishName);
            headerColumn.add((String)chineseName);
            head.add(headerColumn);
        });
        List selectFields = dynamicExportParam.getFieldMap().keySet().stream().map(DSL::field).collect(Collectors.toList());
        Table table = DSL.table((Name)DSL.name((String)tableName));
        Condition condition = DynamicUtil.getDynamicFieldQueryParamCondition(dynamicExportParam);
        condition = this.setTenantIdCondition(condition);
        Result result = this.dsl.select(selectFields).from((TableLike)table).where(condition).orderBy((OrderField[])dynamicExportParam.getOrders().stream().map(order -> DSL.field((Name)DSL.name((String)order.getColumn()), Object.class).sort(order.isAsc() ? SortOrder.ASC : SortOrder.DESC)).toArray(SortField[]::new)).fetch();
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        if (result != null && result.size() > 0) {
            result.intoMaps().stream().map(map -> map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(stringObjectEntry -> {
                if (Timestamp.class.isAssignableFrom(stringObjectEntry.getClass())) {
                    return ((Timestamp)stringObjectEntry.getValue()).toLocalDateTime();
                }
                return stringObjectEntry.getValue();
            }).collect(Collectors.toList())).collect(Collectors.toList());
        }
        try {
            DynamicUtil.writeResponseXlsx(tableName, response, head, dataList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ApiResult<DynamicImportResult> dynamicImport(String boModelCode, MultipartFile file) {
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        String tableName = boModelDo.getDatabaseTableName();
        DynamicImportResult dynamicImportResult = new DynamicImportResult();
        List<Map<String, Object>> dataList = null;
        try {
            dataList = DynamicUtil.readExcelAsMap(file);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25" + e.getMessage()));
        }
        Table table = DSL.table((Name)DSL.name((String)tableName));
        int row = 0;
        for (Map<String, Object> rowData : dataList) {
            ++row;
            try {
                InsertSetStep insertStep = this.dsl.insertInto(table);
                this.dbAuditFieldService.fillInsertAuditFields(rowData);
                rowData.forEach((key, value) -> insertStep.set(DSL.field((String)key), value));
                insertStep.columns(new Field[0]).execute();
            }
            catch (Exception e) {
                DynamicImportFailures dynamicImportFailures = new DynamicImportFailures();
                dynamicImportFailures.setFailuresDate(rowData);
                dynamicImportFailures.setFailuresDescription("\u57f7\u884c\u5f02\u5e38\uff1a" + e.getMessage());
                dynamicImportFailures.setFailuresRow(row);
                dynamicImportResult.getFailuresDescription().add(dynamicImportFailures);
                dynamicImportResult.setFailures(dynamicImportResult.getFailures() + 1);
                continue;
            }
            dynamicImportResult.setSuccessful(dynamicImportResult.getSuccessful() + 1);
        }
        return ApiResult.ok((Object)dynamicImportResult);
    }

    @Override
    public ApiResult<?> delete(String boModelCode, Long id) {
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        String tableName = boModelDo.getDatabaseTableName();
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionByBoModelCodeDos(boModelCode);
        if (boFieldDefinitionDoList == null || boFieldDefinitionDoList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230Bo\u5b57\u6bb5");
        }
        Condition condition = DSL.field((Name)DSL.name((String)ID)).eq((Object)id);
        this.setTenantIdCondition(condition);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        this.dsl.deleteFrom(table).where(condition).execute();
        return ApiResult.ok();
    }

    @Override
    public ApiResult<?> deleteBatch(String boModelCode, List<Long> ids) {
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        String tableName = boModelDo.getDatabaseTableName();
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionByBoModelCodeDos(boModelCode);
        if (boFieldDefinitionDoList == null || boFieldDefinitionDoList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230Bo\u5b57\u6bb5");
        }
        Condition condition = DSL.field((Name)DSL.name((String)ID)).in(ids);
        this.setTenantIdCondition(condition);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        this.dsl.deleteFrom(table).where(condition).execute();
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public ApiResult<Object> insertBatch(String boModelCode, List<Map<String, Object>> entityDataList) {
        for (Map<String, Object> stringObjectMap : entityDataList) {
            this.insert(boModelCode, stringObjectMap);
        }
        return ApiResult.ok();
    }

    private static void boFiledCheck(Map<String, DynamicBoFieldDefinitionDO> map, Map<String, Object> entityData) {
        if (entityData == null || entityData.size() == 0) {
            throw new BusinessException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        entityData.forEach((key, value) -> {
            if (!map.containsKey(key)) {
                throw new BusinessException("\u672a\u627e\u5230Bo\u5b57\u6bb5\uff1a" + key);
            }
        });
    }

    private List<DynamicBoFieldDefinitionDO> getBoFieldDefinitionByBoModelCodeDos(String boModelCode) {
        DynamicBoModelVo boModelDo = this.boModelService.getBoModelVoByCode(boModelCode);
        String tableName = boModelDo.getDatabaseTableName();
        BoFieldQueryParam boFieldParam = new BoFieldQueryParam();
        boFieldParam.setDbField(true);
        boFieldParam.setDbTableName(tableName);
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.boFieldDefinitionService.searchBoFieldList(boFieldParam);
        return boFieldDefinitionDoList;
    }

    private Condition setTenantIdCondition(Condition condition) {
        Long tenantId = this.dbAuditFieldService.getCurrentTenantId();
        if (tenantId == null) {
            tenantId = -1L;
        }
        Field tenantIdField = DSL.field((Name)DSL.name((String)TENANT_ID), Long.class);
        return condition.and(tenantIdField.eq((Object)tenantId));
    }

    private Map<String, DynamicBoFieldDefinitionDO> buildFieldDefinitionMap(List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList) {
        return boFieldDefinitionDoList.stream().collect(Collectors.toMap(def -> def.getBasicKey(), def -> def));
    }
}

