/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorBoModelRelationDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAndConfiguratorRelation;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorRelationBoModelParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.ConfiguratorRelationBoModelVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorBoModelRelationRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorBoModelRelationService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorService;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicConfiguratorBoModelRelationServiceImpl
implements DynamicConfiguratorBoModelRelationService {
    private final BoModelRepository repository;
    private final ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository;
    private final DynamicBoModelService boModelService;
    private final DynamicConfiguratorService dynamicConfiguratorService;
    private final DynamicBoFieldDefinitionService boFieldDefinitionService;

    public DynamicConfiguratorBoModelRelationServiceImpl(BoModelRepository repository, ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository, DynamicBoModelService boModelService, DynamicConfiguratorService dynamicConfiguratorService, DynamicBoFieldDefinitionService boFieldDefinitionService) {
        this.repository = repository;
        this.configuratorBoModelRelationRepository = configuratorBoModelRelationRepository;
        this.boModelService = boModelService;
        this.dynamicConfiguratorService = dynamicConfiguratorService;
        this.boFieldDefinitionService = boFieldDefinitionService;
    }

    @Override
    @Transactional
    public ApiResult<Long> createBoModelAndConfigurator(BoModelAndConfiguratorRelation boModelParam) {
        BoModelSaveParam boSaveModelParam = new BoModelSaveParam();
        boSaveModelParam.setBoModelCode(boModelParam.getBoModelCode());
        boSaveModelParam.setDatabaseTableName(boModelParam.getDatabaseTableName());
        boSaveModelParam.setDescription(boModelParam.getDescription());
        ApiResult<Long> result = this.boModelService.createBoModel(boSaveModelParam);
        this.boModelAndConfiguratorRelation(boModelParam);
        return result;
    }

    @Override
    @Transactional
    public ApiResult<String> boModelAndConfiguratorRelation(BoModelAndConfiguratorRelation boModelParam) {
        DynamicConfiguratorBoModelRelationDO rdo = new DynamicConfiguratorBoModelRelationDO();
        rdo.setDynamicConfiguratorCode(boModelParam.getDynamicConfiguratorCode());
        rdo.setBoModelCode(boModelParam.getBoModelCode());
        rdo.setBoModelType(boModelParam.getBoModelType());
        this.configuratorBoModelRelationRepository.save((Object)rdo);
        return ApiResult.ok((Object)rdo.getId().toString());
    }

    @Override
    public ApiResult<String> removeBoModelAndConfiguratorRelation(BoModelAndConfiguratorRelation boModelParam) {
        Predicate predicate = DynamicConfiguratorBoModelRelationService.getPredicateByParam(boModelParam);
        this.configuratorBoModelRelationRepository.findAll(predicate).forEach(dynamicConfiguratorBoModelRelationDo -> this.configuratorBoModelRelationRepository.deleteById(dynamicConfiguratorBoModelRelationDo.getId()));
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public void deleteConfigurator(Long configuratorId) {
        DynamicConfiguratorDO dynamicConfiguratorDO = this.dynamicConfiguratorService.getConfiguratorById(configuratorId);
        ConfiguratorRelationBoModelParam configuratorRelationBoModelParam = new ConfiguratorRelationBoModelParam();
        configuratorRelationBoModelParam.setDynamicConfiguratorCode(dynamicConfiguratorDO.getDynamicConfiguratorCode());
        ApiResult<ConfiguratorRelationBoModelVO> configuratorRelationBoModelVOApiResult = this.getConfiguratorRelationBoModel(configuratorRelationBoModelParam);
        if (configuratorRelationBoModelVOApiResult.isSuccess() && configuratorRelationBoModelVOApiResult.getData() != null) {
            ConfiguratorRelationBoModelVO relationVo = (ConfiguratorRelationBoModelVO)configuratorRelationBoModelVOApiResult.getData();
            List<DynamicBoModelVo> boModelVoList = relationVo.getBoModelVo();
            boModelVoList.forEach(vo -> {
                this.boModelService.deleteBoModel(vo.getBoModelCode());
                this.boFieldDefinitionService.deleteByBoCode(vo.getBoModelCode());
            });
        }
        BoModelAndConfiguratorRelation boModelAndConfiguratorRelation = new BoModelAndConfiguratorRelation();
        boModelAndConfiguratorRelation.setDynamicConfiguratorCode(dynamicConfiguratorDO.getDynamicConfiguratorCode());
        this.removeBoModelAndConfiguratorRelation(boModelAndConfiguratorRelation);
        this.dynamicConfiguratorService.deleteConfigurator(configuratorId);
    }

    @Override
    public ApiResult<ConfiguratorRelationBoModelVO> getConfiguratorRelationBoModel(ConfiguratorRelationBoModelParam param) {
        DynamicConfiguratorDO configDo = this.dynamicConfiguratorService.getConfiguratorByCode(param.getDynamicConfiguratorCode());
        if (configDo == null) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u914d\u7f6e");
        }
        ConfiguratorRelationBoModelVO configuratorRelationBoModelVO = new ConfiguratorRelationBoModelVO();
        configuratorRelationBoModelVO.setDynamicConfiguratorDo(configDo);
        BoModelAndConfiguratorRelation boModelParam = new BoModelAndConfiguratorRelation();
        boModelParam.setDynamicConfiguratorCode(param.getDynamicConfiguratorCode());
        Predicate predicate = DynamicConfiguratorBoModelRelationService.getPredicateByParam(boModelParam);
        ArrayList<DynamicBoModelVo> list = new ArrayList<DynamicBoModelVo>();
        this.configuratorBoModelRelationRepository.findAll(predicate).iterator().forEachRemaining(dynamicConfiguratorBoModelRelationDo -> {
            DynamicBoModelVo boModelVo = this.boModelService.getBoModelVoByCode(dynamicConfiguratorBoModelRelationDo.getBoModelCode());
            boModelVo.setBoModelType(dynamicConfiguratorBoModelRelationDo.getBoModelType());
            list.add(boModelVo);
        });
        configuratorRelationBoModelVO.setBoModelVo(list);
        return ApiResult.ok((Object)configuratorRelationBoModelVO);
    }
}

