/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorService;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicConfiguratorServiceImpl
implements DynamicConfiguratorService {
    @Autowired
    private ConfiguratorRepository repository;

    @Override
    @Transactional
    public ApiResult<Long> createConfigurator(ConfiguratorSaveParam configuratorParam) {
        ConfiguratorQueryParam qParam = new ConfiguratorQueryParam();
        qParam.setDynamicConfiguratorCode(configuratorParam.getDynamicConfiguratorCode());
        Predicate predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(qParam);
        Optional configurator = this.repository.findOne(predicate);
        if (configurator.isPresent()) {
            return ApiResult.fail((String)("\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d\uff1a" + configuratorParam.getDynamicConfiguratorCode()));
        }
        DynamicConfiguratorDO configuratorEntity = new DynamicConfiguratorDO();
        BeanUtils.copyProperties((Object)configuratorParam, (Object)((Object)configuratorEntity));
        this.repository.save((Object)configuratorEntity);
        return ApiResult.ok((Object)configuratorEntity.getId());
    }

    @Override
    public DynamicConfiguratorDO getConfiguratorById(Long id) {
        return (DynamicConfiguratorDO)((Object)this.repository.findById(id).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5ID\u7684\u914d\u7f6e\u5668 :: " + id)));
    }

    @Override
    public DynamicConfiguratorDO getConfiguratorByCode(String configuratorCode) {
        ConfiguratorQueryParam qParam = new ConfiguratorQueryParam();
        qParam.setDynamicConfiguratorCode(configuratorCode);
        Predicate predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(qParam);
        DynamicConfiguratorDO configuratorDo = this.repository.findOne(predicate).orElse(null);
        return configuratorDo;
    }

    @Override
    @Transactional
    public ApiResult<Boolean> updateConfigurator(Long id, ConfiguratorUpdateParam configuratorDetails) {
        DynamicConfiguratorDO configurator = (DynamicConfiguratorDO)((Object)this.repository.findById(id).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5ID\u7684\u914d\u7f6e\u5668 :: " + id)));
        if (configuratorDetails.getDynamicConfiguratorName() != null) {
            configurator.setDynamicConfiguratorName(configuratorDetails.getDynamicConfiguratorName());
        }
        if (configuratorDetails.getDynamicConfiguratorType() != null) {
            configurator.setDynamicConfiguratorType(configuratorDetails.getDynamicConfiguratorType());
        }
        if (configuratorDetails.getLayoutTemplateCode() != null) {
            configurator.setLayoutTemplateCode(configuratorDetails.getLayoutTemplateCode());
        }
        if (configuratorDetails.getLayoutTemplateName() != null) {
            configurator.setLayoutTemplateName(configuratorDetails.getLayoutTemplateName());
        }
        if (configuratorDetails.getDynamicConfiguratorStatus() != null) {
            configurator.setDynamicConfiguratorStatus(configuratorDetails.getDynamicConfiguratorStatus());
        }
        if (configuratorDetails.getDynamicConfiguratorDescription() != null) {
            configurator.setDynamicConfiguratorDescription(configuratorDetails.getDynamicConfiguratorDescription());
        }
        if (configuratorDetails.getFrontendExtensionJson() != null) {
            configurator.setFrontendExtensionJson(configuratorDetails.getFrontendExtensionJson());
        }
        this.repository.save((Object)configurator);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional
    public void deleteConfigurator(Long id) {
        this.repository.deleteById(id);
    }

    @Override
    public ApiResult<PagingVO<DynamicConfiguratorDO>> searchConfigurators(ConfiguratorQueryParam configuratorParam) {
        Predicate predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(configuratorParam);
        Page page = this.repository.findAll(predicate, (Pageable)configuratorParam.getPageRequest());
        PagingVO pagingVO = PagingVO.builder().total(page.getTotalElements()).setRecords(page.getContent());
        return ApiResult.ok((Object)pagingVO);
    }

    @Override
    public ApiResult<List<DynamicConfiguratorDO>> searchConfiguratorList(ConfiguratorQueryParam configuratorParam) {
        Predicate predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(configuratorParam);
        ArrayList doList = new ArrayList();
        this.repository.findAll(predicate).iterator().forEachRemaining(configuratorDo -> doList.add(configuratorDo));
        return ApiResult.ok(doList);
    }
}

