package com.elitescloud.cloudt.lowcode.dynamic.common;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;

/**
 * 审批类型.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/18
 */
public class ApproveTypeUdc extends BaseUdc<ApproveTypeUdc> {
    private static final long serialVersionUID = -6405907516842665157L;
    public static final String UDC_CODE = "approveType";

    public static final ApproveTypeUdc EMPTY = new ApproveTypeUdc("empty", "无需审批");
    public static final ApproveTypeUdc SIMPLE = new ApproveTypeUdc("simple", "简单审批");
    public static final ApproveTypeUdc WORKFLOW = new ApproveTypeUdc("workflow", "流程引擎审批");

    public ApproveTypeUdc() {
    }

    public ApproveTypeUdc(String value) {
        super(value);
    }

    public ApproveTypeUdc(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String getUdcCode() {
        return UDC_CODE;
    }
}
