package com.elitescloud.cloudt.lowcode.dynamic.controller;

import cn.hutool.db.meta.Table;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jooq.DSLContext;
import org.springframework.web.bind.annotation.*;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.List;


/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-25 19:54
 */
@RestController
@RequestMapping("/dynamic/db/metadata")
@Api(value = "DB元数据", tags = {"DB元数据"})
public class DbMetadaController {


    private final DbTableService dbTableService;
    private final DbDataSourceMetadataService dbDataSourceMetadataService;

     private final  DbMetadataService dbMetadataService;

    public DbMetadaController(DbTableService dbTableService, DbDataSourceMetadataService dbDataSourceMetadataService,
                              DbMetadataService dbMetadataService) {
        this.dbMetadataService = dbMetadataService;
        this.dbTableService = dbTableService;
        this.dbDataSourceMetadataService = dbDataSourceMetadataService;
    }

    @PostMapping("/getTableMeta")
    @ApiOperation(value = "检索表元数据-当前数据源", notes = "检索表元数据-当前数据源")
    public ApiResult<Table> getTableMeta(@RequestBody DbTableParam dbTableParam) {
        var table = dbDataSourceMetadataService.getTableMeta( dbTableParam.getCatalog(),
                dbTableParam.getSchema(), dbTableParam.getTableName());
        return ApiResult.ok(table);
    }
    @GetMapping("/getCurrentSchema")
    @ApiOperation(value = "查询默认schema-当前数据源", notes = "查询默认schema-当前数据源")
    public ApiResult<String> getCurrentSchema() {
        try {
            String schemaName=dbDataSourceMetadataService.getSchema();
            if(schemaName==null||schemaName.isBlank()) {
                schemaName= dbMetadataService.getCurrentSchema();
            }
            return ApiResult.ok(schemaName);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/getAllSchema")
    @ApiOperation(value = "【需授权mysql】查询q全部schema-当前数据源", notes = "查询默认schema-当前数据源")
    public ApiResult<List<String>> getAllSchema() {
        try {
            return ApiResult.ok(dbMetadataService.getAllSchemas());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/getAllTableNames")
    @ApiOperation(value = "获取全部表名-当前数据源与默认schema", notes = "获取全部表名-当前数据源与默认schema")
    public ApiResult<List<String>> getAllTableNames() {
        return ApiResult.ok(dbDataSourceMetadataService.getAllTableNames());
    }

    @PostMapping("/getSchemaTableNames")
    @ApiOperation(value = "检索schema的全部表名-当前数据源", notes = "获取schema的全部表名-当前数据源")
    public ApiResult<List<String>> getSchemaTableNames(@RequestBody DbTableParam dbTableParam) {
        return ApiResult.ok(dbDataSourceMetadataService.getSchemaTableNames(dbTableParam.getCatalog(),dbTableParam.getSchema()));
    }
    @PostMapping("/getTableColumnNames")
    @ApiOperation(value = "检索获取表全部列名-当前数据源默认schema", notes = "检索获取表全部列名-当前数据源默认schema")
    public ApiResult<List<String>> getTableColumnNames(@RequestBody DbTableParam dbTableParam) {
        var tableColumn = dbDataSourceMetadataService.getAllTableColumnNames(dbTableParam.getCatalog(),dbTableParam.getSchema(),
                dbTableParam.getTableName());
        return ApiResult.ok(tableColumn);
    }


}