
package com.elitescloud.cloudt.lowcode.dynamic.controller;


import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.SearchResult;
import com.elitescloud.boot.core.support.customfield.model.BasicUdcVO;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldBatchSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.sbean.DynamicBoFieldDefinitionQueryBean;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl.DynamicBoFieldDefinitionServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/dynamic/boFieldDefinition")
@Api(value = "动态业务模型-业务模型字段管理", tags = {"动态业务模型-业务模型字段管理"})
public class DynamicBoFieldDefinitionController {
   private final DynamicBoFieldDefinitionServiceImpl boFieldService;
   private BeanSearcher beanSearcher;

   private MapSearcher mapSearcher;

   public DynamicBoFieldDefinitionController(BeanSearcherFactory beanSearcherFactory,
                                             DynamicBoFieldDefinitionServiceImpl boFieldService) {
      this.boFieldService = boFieldService;
      this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
      this.mapSearcher = beanSearcherFactory.getMapBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
   }

   @GetMapping("/udc/boModelFieldTypeEnum")
   @ApiOperation(value = "返回模型字段类型枚举", notes = "返回模型字段类型枚举")
   public ApiResult<List<BasicUdcVO>> getBoModelFieldTypeEnum() {
      return ApiResult.ok(BoModelFieldTypeEnum.getSysUdcVOList());
   }

   @PostMapping("/searcher/page")
   @ApiOperation(value = "分页查询检索-beansearcher", notes = "分页查询检索-beansearche")
   public ApiResult<SearchResult<DynamicBoFieldDefinitionQueryBean>> pageSearcher(
           @RequestBody Map<String, Object> param, HttpServletRequest request) {
      var obj = beanSearcher.search(DynamicBoFieldDefinitionQueryBean.class, param);
      return ApiResult.ok(obj);
   }

   @PostMapping("/query/page")
   @ApiOperation(value = "分页查询", notes = "分页查询")
   public ApiResult<PagingVO<DynamicBoFieldDefinitionDO>> pageQuery(
           @RequestBody BoFieldQueryParam  param, HttpServletRequest request) {
      var obj = boFieldService.searchBoFields( param);
      return ApiResult.ok(obj);
   }
   @PostMapping("/query/list")
   @ApiOperation(value = "查询", notes = "查询")
   public ApiResult<List<DynamicBoFieldDefinitionDO>> queryList(
           @RequestBody BoFieldQueryParam  param, HttpServletRequest request) {
      var obj = boFieldService.searchBoFieldList( param);
      return ApiResult.ok(obj);
   }

   @PostMapping("/createBoField")
   @ApiOperation(value = "创建字段", notes = "创建字段")
   public ApiResult createBoField(@RequestBody BoFieldDefinitionSaveParam param) {
      return boFieldService.createBoField(param);
   }
   @PostMapping("/boFieldBatchSave")
   @ApiOperation(value = "保存bo模型的字段-批量全删全插", notes = "保存bo模型字段-批量全删全插")
   public ApiResult boFieldBatchSave(@RequestBody @Valid BoFieldBatchSaveParam param) {
      return boFieldService.boFieldBatchSave(param);
   }

   @GetMapping("/getBoFieldById/{id}")
   public ApiResult<DynamicBoFieldDefinitionDO> getBoFieldById(@PathVariable Long id) {
      return ApiResult.ok(boFieldService.getBoFieldById(id));
   }

   @PutMapping("/updateBoField/{id}")
   public ApiResult<Boolean> updateBoField(@PathVariable Long id,
                                            @RequestBody BoFieldDefinitionUpdateParam param) {
      return boFieldService.updateBoField(id, param);
   }

   @DeleteMapping("/deleteBoField/{id}")
   public ApiResult<Boolean> deleteBoField(@PathVariable Long id) {
      boFieldService.deleteBoField(id);
      return ApiResult.ok(true);
   }



}
