package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

/**
 * @author : chen.niu
 * @description : 动态配置表
 * @date : 2024-04-03 16:51
 */

import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Map;

@Entity
@Table(name = TableNameConstant.DYNAMIC_CONFIGURATOR,
        indexes = {
                @Index(name = "idx_dynamicf_code", columnList = "dynamicConfiguratorCode"),
                @Index(name = "idx_dynamicf_approvalkey", columnList = "approvalKey"),
        }
)
@Comment("功能模块")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class DynamicConfiguratorDO extends BaseModel {
    private static final long serialVersionUID = 7191578411951802750L;

    @Comment("功能模块编码，唯一标识")
    @Column(nullable = false)
    private String dynamicConfiguratorCode;

    @Comment("功能模块名称")
    @Column()
    private String dynamicConfiguratorName;

    @Comment("功能模块表类型（单表/主表明细表）")
    @Column()
    private String dynamicConfiguratorType;

    @Comment("前端展示布局模板编码")
    @Column()
    private String layoutTemplateCode;

    @Comment("前端展示布局模板名称")
    @Column()
    private String layoutTemplateName;

    @Comment("状态")
    @Column()
    private String dynamicConfiguratorStatus;

    @Comment("描述")
    @Column()
    private String dynamicConfiguratorDescription;

    @Comment("功能模块操作JSON")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> operateJson;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Comment("表单展示JSON")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> formJson;

    @Comment("列表展示JSON")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> listPageJson;

    @Comment("前端扩展字段json")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> frontendExtensionJson;

    @Comment(value = "是否已创建审批流程", defaultValue = "0")
    @Column()
    private Boolean createdApproval;

    @Comment(value = "是否已部署审批流程", defaultValue = "0")
    @Column()
    private Boolean deployedApproval;

    /**
     * 审批类型 UDC[cloudt-system:approveType]
     * <p>
     * {@link com.elitescloud.cloudt.lowcode.dynamic.common.ApproveTypeUdc}
     */
    @Comment("流程审批类型")
    @Column()
    private String approvalType;

    @Comment("工作流引擎")
    @Column()
    private String approvalEngine;

    @Comment("流程定义Key")
    @Column()
    private String approvalKey;

    @Comment("流程JSON")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> approvalJson;

    @Comment(value = "是否已发布", defaultValue = "0")
    @Column()
    private Boolean published;

    @Comment("发布应用编码")
    @Column()
    private String appCode;

    @Comment("发布后菜单编码")
    @Column()
    private String menuCode;

    @Comment(value = "是否已部署", defaultValue = "0")
    @Column()
    private Boolean deployed;
}