package com.elitescloud.cloudt.lowcode.dynamic.model.vo.query;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * 功能模块分页查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Getter
@Setter
@ApiModel(description = "功能模块分页查询参数")
public class DynamicConfiguratorPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -7858230288450609556L;

    @NotBlank(message = "功能模块编码为空")
    private String dynamicConfiguratorCode;

    @NotBlank(message = "功能模块名称为空")
    private String dynamicConfiguratorName;

    @ApiModelProperty(value = "流程审批类型，UDC[cloudt-system:approveType]")
    private String approvalType;

    @NotBlank(message = "启用状态")
    private Boolean enabled;

    @NotBlank(message = "是否已发布")
    private Boolean published;

    @NotBlank(message = "是否已部署")
    private Boolean deployed;
}
