package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataMetaUtil;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-16 10:54
 */
@Service
@Slf4j
public class DbDataSourceMetadataServiceImpl implements DbDataSourceMetadataService {
    private final DataSource dataSource;

    public DbDataSourceMetadataServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getSchema() throws SQLException {
         return DbDataMetaUtil.getSchema(dataSource.getConnection());
    }

    /**
     * 获取当前的数据库模式。
     *
     * @return 返回当前使用的数据库模式名称。
     */
    @Override
    public Table getTableMeta(String catalog, String schema, String tableName) {
        return DbDataMetaUtil.getTableMeta(dataSource, catalog, schema, tableName);
    }

    @Override
    public List<String> getAllTableNames() {
        return DbDataMetaUtil.getTables(dataSource);
    }


    @Override
    public List<String> getAllTableColumnNames(String catalog,String schema,String tableName) {
        if(schema==null||schema.isBlank()){
            return List.of(DbDataMetaUtil.getColumnNames(dataSource, tableName));
        }else{
            return List.of(DbDataMetaUtil.getColumnNamesByCatalog(dataSource, catalog,schema, tableName));
        }
    }


    @Override
    public List<String> getSchemaTableNames(String catalog,String schema) {
        return DbDataMetaUtil.getTablesByCatalog(dataSource,catalog,schema);
    }



}
