package com.elitescloud.cloudt.lowcode.dynamic.service.id;

import org.redisson.api.RandomIdGenerator;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 11:24
 */
public class IdGeneratorFactory {

    public static final String CLOUDT = "cloudt";
    public static final String DB_AUTO = "db_auto";

    public static DynamicIdGeneratorService getIdGenerator(String strategy) {
        switch (strategy) {
            case CLOUDT:
                return new DynamicIdGeneratorCloudtService();
            case DB_AUTO:
                return null;
            // 可以根据需要添加其他策略
            default:
                throw new IllegalArgumentException("Unknown strategy: " + strategy);
        }
    }
}
