package com.elitescloud.cloudt.lowcode.dynamic.service.spi;

import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.ProcDefInfo;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.WorkflowStatus;

/**
 * 流程引擎.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/24
 */
public interface DynamicWorkflowEngine {

    /**
     * 引擎类型
     *
     * @return 引擎类型
     */
    String engineType();

    /**
     * 引擎名称
     *
     * @return 引擎名称
     */
    String engineName();

    /**
     * 获取流程引擎状态
     *
     * @return 状态
     */
    WorkflowStatus getEngineStatus();

    /**
     * 获取流程定义信息
     *
     * @param procDefKey 流程定义Key
     * @return 流程定义信息
     */
    ProcDefInfo getProcDefInfo(String procDefKey);

    /**
     * 创建流程
     *
     * @param procDefInfo 流程定义信息
     * @return 创建结果
     */
    String createProcDef(ProcDefInfo procDefInfo);

    /**
     * 部署流程
     *
     * @param procDefKey 流程定义Key
     * @return 部署结果
     */
    String deploy(String procDefKey);

    /**
     * 删除流程
     *
     * @param procDefKey 流程定义Key
     * @return 删除结果
     */
    String deleteProcDef(String procDefKey);
}
