package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicExportParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportResult;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-25 19:54
 */
@RestController
@RequestMapping("/dynamic/bo/api")
@Api(value = "动态API-业务模型", tags = {"动态API-业务模型"})
@Slf4j
public class DynamicApiBoController {
    private final DynamicBoApiService dynamicApiService;
    public DynamicApiBoController(DynamicBoApiService dynamicApiService) {
        this.dynamicApiService = dynamicApiService;
    }

    @PostMapping("/{boModelCode}/insert")
    @ApiOperation(value = "插入{业务模型编码}{插入数据}Map<String, Object>", notes = "插入{业务模型编码}")
    public ApiResult<Object> insert(@PathVariable String boModelCode,
                                    @RequestBody Map<String, Object> entityData) {
        return dynamicApiService.insert(boModelCode, entityData);
    }
    @PostMapping("/{boModelCode}/insertBatch")
    @ApiOperation(value = "批量插入{业务模型编码}{插入数据} List<Map<String, Object>>", notes = "批量插入{业务模型编码} List<Map<String, Object>>")
    public ApiResult<Object> insertBatch(@PathVariable String boModelCode,
                                    @RequestBody List<Map<String, Object>> entityDataList) {
        return dynamicApiService.insertBatch(boModelCode, entityDataList);
    }

    @PutMapping("/{boModelCode}/{id}/update")
    @ApiOperation(value = "更新{业务模型编码}{查询数据ID}{更新数据}", notes = "更新{业务模型编码}")
    public ApiResult<Integer> update(@PathVariable String boModelCode, @PathVariable Long id,
                                     @RequestBody Map<String, Object> entityData) {
        return dynamicApiService.update(boModelCode, id, entityData);
    }

    @PutMapping("/{boModelCode}/updateBatch")
    @ApiOperation(value = "批量更新{业务模型编码}【更新数据id：{更新数据map}】", notes = "更新{业务模型编码}")
    public ApiResult<Integer> updateBatch(@PathVariable String boModelCode,
                                     @RequestBody Map<Long,Map<String, Object>> entityDataList) {
        return dynamicApiService.updateBatch(boModelCode,  entityDataList);
    }
    @PostMapping("/{boModelCode}/queryPage/")
    @ApiOperation(value = "查询{业务模型编码}{查询条件}", notes = "查询{业务模型编码}")
    public ApiResult<Page<?>> queryPage(@PathVariable String boModelCode,
                                        @RequestBody DynamicFieldQueryParam queryParam) {
        return dynamicApiService.queryPage(boModelCode, queryParam);
    }

    @GetMapping("/{boModelCode}/{id}/getById")
    @ApiOperation(value = "查询{业务模型编码}{查询数据ID}", notes = "查询{业务模型编码}")
    public ApiResult<Map> getById(@PathVariable String boModelCode,
                                  @PathVariable Long id) {
        return dynamicApiService.getById(boModelCode, id);
    }

    @PostMapping("/{boModelCode}/export")
    @ApiOperation(value = "导出{业务模型编码}", notes = "导出{业务模型编码}")
    public void dynamicExport(@PathVariable String boModelCode, @RequestBody DynamicExportParam dynamicExportParam, HttpServletResponse response)
            throws IOException {
        dynamicApiService.dynamicExport(boModelCode, dynamicExportParam, response);
    }

    @PostMapping("/{boModelCode}/import")
    @ApiOperation(value = "导入{业务模型编码}", notes = "导入{业务模型编码}")
    public ApiResult<DynamicImportResult>  dynamicImport(@PathVariable String boModelCode,
                                                         @RequestParam("file") MultipartFile file) throws IOException {
        return dynamicApiService.dynamicImport(boModelCode, file);
    }

    @DeleteMapping("/{boModelCode}/{id}/delete")
    @ApiOperation(value = "删除{业务模型编码}{删除数据ID}", notes = "删除{业务模型编码}{删除数据ID}")
    public ApiResult<?> delete(@PathVariable String boModelCode, @PathVariable Long id) {
        return dynamicApiService.delete(boModelCode, id);
    }

    @DeleteMapping("/{boModelCode}/deleteBatch")
    @ApiOperation(value = "批量删除{业务模型编码}{删除数据ID}", notes = "批量删除{业务模型编码}{删除数据ID}")
    public ApiResult<?> deleteBatch(@PathVariable String boModelCode, @RequestBody List<Long> ids) {
        return dynamicApiService.deleteBatch(boModelCode, ids);
    }
}
