package com.elitescloud.cloudt.lowcode.dynamic.model.convert;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 18:53
 */
import com.elitescloud.boot.core.support.customfield.common.BasicUdcEnumInterface;
import com.elitescloud.boot.core.support.customfield.model.BasicUdcVO;
import org.jooq.impl.SQLDataType;

import java.util.ArrayList;
import java.util.List;

public enum BoModelFieldTypeEnum implements BasicUdcEnumInterface {
    STRING("SYSTEM", "STRING", "字段类型", "文本", 1),
    BOOLEAN("SYSTEM", "BOOLEAN", "字段类型", "布尔", 2),
    INTEGER("SYSTEM", "INTEGER", "字段类型", "整数", 3),
    LONG("SYSTEM", "LONG", "字段类型", "长整数", 5),

//    FLOAT("SYSTEM", "FLOAT", "字段类型", "单精度浮点数", 6),
    DOUBLE("SYSTEM", "DOUBLE", "字段类型", "小数", 7),
    MONEY("SYSTEM", "MONEY", "字段类型", "金额", 7),
    DATE("SYSTEM", "DATE", "字段类型", "日期", 8),
    DATE_TIME("SYSTEM", "DATE_TIME", "字段类型", "日期时间", 9),
//    BYTE("SYSTEM", "BYTE", "字段类型", "字节", 3),

//    BINARY("SYSTEM", "BINARY", "字段类型", "二进制", 4),
//    URI("SYSTEM", "URI", "字段类型", "统一资源标识符", 5),
//    URL("SYSTEM", "URL", "字段类型", "统一资源定位器", 6),
    EMAIL("SYSTEM", "EMAIL", "字段类型", "电子邮件地址", 7),
//    UUID("SYSTEM", "UUID", "字段类型", "通用唯一标识符", 8),
//    INT("SYSTEM", "INT", "字段类型", "整数", 9),



//    DECIMAL("SYSTEM", "DECIMAL", "字段类型", "十进制数", 14),
//    NUMBER("SYSTEM", "NUMBER", "字段类型", "数字", 15),

//    PARTIAL_TIME("SYSTEM", "PARTIAL_TIME", "字段类型", "部分时间", 18),
//    FILE("SYSTEM", "FILE", "字段类型", "文件", 19),
//    OBJECT("SYSTEM", "OBJECT", "字段类型", "对象", 20)
    ;

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String valueDescription;
    private final int sortNo;
    private final BasicUdcVO sysUdcVO;

    BoModelFieldTypeEnum(String domainCode, String udcCode, String udcName, String valueDescription, int sortNo) {
        this.domainCode = domainCode;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = valueDescription;
        this.sortNo = sortNo;
        this.sysUdcVO = newUdcVo(domainCode, udcCode, udcName, valueDescription, sortNo, this.name());
    }

    @Override
    public BasicUdcVO getUdcVO() {
        return sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (BoModelFieldTypeEnum ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }

    public static List<BasicUdcVO> getSysUdcVOList() {
        List<BasicUdcVO> sysUdcVOList = new ArrayList<>();
        for (BoModelFieldTypeEnum ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }

    // 添加一个方法来获取对应的 SQLDataType
    public org.jooq.DataType<?>  getJooqDataType() {
        switch (this) {
            case STRING:
                return SQLDataType.VARCHAR(500); // 假设字符串类型映射为 VARCHAR
            case BOOLEAN:
                return SQLDataType.BOOLEAN;
            case EMAIL:
                return SQLDataType.VARCHAR(500);
            case MONEY:
                return SQLDataType.DOUBLE;
//            case BYTE:
//                return SQLDataType.TINYINT; // 假设字节类型映射为 TINYINT
//            case BINARY:
//                return SQLDataType.BINARY;
            case LONG:
                return SQLDataType.BIGINT;
//            case FLOAT:
//                return SQLDataType.FLOAT;
            case DOUBLE:
                return SQLDataType.DOUBLE;
            case INTEGER:
                return SQLDataType.BIGINT; // 注意：INT 和 INTEGER 通常可以互换
//            case DECIMAL:
//                return SQLDataType.DECIMAL;
            case DATE:
                return SQLDataType.LOCALDATE;
            case DATE_TIME:
                return SQLDataType.LOCALDATETIME;
            // ... 其他类型的映射 ...
            default:
                throw new IllegalStateException("Unsupported field type: " + this);
        }
    }
}

