package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

import cn.hutool.db.meta.IndexInfo;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.google.gson.Gson;
import lombok.Data;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.*;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 11:47
 */
@Data
@Entity
@Table(name = "lowcode_db_table", indexes = {
})
@Comment("数据库表")
public class DbTableDo extends BaseModel {
    private static final long serialVersionUID = -2876262824273923666L;

    private String tableCatalog; // 数据库的目录名（通常是可以忽略的）
    private String tableSchema; // 数据库的模式名
    private String tableName; // 表的名称
    private String tableType; // 表的类型，例如 'BASE TABLE' 或 'VIEW'
    private String engine; // 使用的存储引擎
    private Integer version; // 表的版本
    private String rowFormat; // 行格式
    private Long tableRows; // 表中的行数
    private Long avgRowLength; // 平均行长度
    private Long dataLength; // 数据长度
    private Long maxDataLength; // 最大数据长度
    private Long indexLength; // 索引长度
    private Long dataFree; // 空闲数据空间
    private Long autoIncrement; // 下一个自增值
    private LocalDateTime createTimeTable; // 表的创建时间
    private LocalDateTime updateTimeTable; // 表的最后更新时间
    private LocalDateTime checkTimeTable; // 表的最后检查时间
    private String tableCollation; // 表的字符集和校对规则
    private Long checksum; // 表的校验和
    private String createOptions; // 创建表时的其他选项
    private String tableComment; // 表的注释
    // 主键字段名列表
//    @Column(columnDefinition = "json")

    @Lob
    private String pkNamesJson;
    /**
     * 索引信息
     */
//    @Column(columnDefinition = "json")
    @Lob
    private String indexInfoListJson;

    public DbTableDo hutoolTableToDo(cn.hutool.db.meta.Table table) {
        this.setTableSchema(table.getSchema());
        this.setTableCatalog(table.getCatalog());
        this.setTableName(table.getTableName());
        this.setTableComment(table.getComment());
        var pkNames =table.getPkNames();
        if(pkNames!=null&&pkNames.size()>0) {
              this.setPkNamesJson( new Gson().toJson(pkNames));
        }
        var indexInfoList = table.getIndexInfoList();
        if(indexInfoList!=null&&indexInfoList.size()>0) {
             this.setIndexLength((long) table.getIndexInfoList().size());
             this.setIndexInfoListJson(new Gson().toJson(indexInfoList));
        }
        return this;
    }
}
