package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 部署记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/25
 */
@Entity
@Table(name = "dynamic_deploy_record", indexes = {
        @Index(name = "idx_dynamicdeploy_configurator", columnList = "dynamicConfiguratorCode"),
})
@Comment("部署记录")
@Getter
@Setter
@DynamicInsert
public class DynamicDeployRecordDO extends BaseModel {
    private static final long serialVersionUID = 7048626155126745837L;

    @Comment("配置能力编码")
    @Column()
    private String dynamicConfiguratorCode;

    @Comment("部署类型")
    @Column(nullable = false)
    private String deployType;

    @Comment("开始部署时间")
    @Column(nullable = false)
    private LocalDateTime startTime;

    @Comment("结束部署时间")
    @Column()
    private LocalDateTime finishTime;

    @Comment(value = "是否结束", defaultValue = "0")
    @Column()
    private Boolean finished;

    @Comment(value = "是否部署成功", defaultValue = "0")
    @Column()
    private Boolean success;

    @Comment(value = "失败原因")
    @Column()
    @Lob
    private String failReason;
}
