package com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 功能模块详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Getter
@Setter
@ApiModel(description = "功能模块详细信息")
public class DynamicConfiguratorDetailRespVO implements Serializable {
    private static final long serialVersionUID = 5526618539339501235L;
    
    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty("功能模块编码")
    private String dynamicConfiguratorCode;

    @ApiModelProperty("功能模块名称")
    private String dynamicConfiguratorName;

    @ApiModelProperty("描述")
    private String dynamicConfiguratorDescription;

    @ApiModelProperty("表单配置")
    private Map<String, Object> formJson;

    @ApiModelProperty("列表展示配置")
    private Map<String, Object> listPageJson;

    @ApiModelProperty("前端扩展字段")
    private Map<String, Object> frontendExtensionJson;

    @ApiModelProperty("功能模块操作配置")
    private Map<String, Object> operateJson;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "是否已创建审批流程")
    private Boolean createdApproval;

    /**
     * 审批类型 UDC[cloudt-system:approveType]
     * <p>
     * {@link com.elitescloud.cloudt.lowcode.dynamic.common.ApproveTypeUdc}
     */
    @ApiModelProperty("流程审批类型")
    private String approvalType;
    private String approvalTypeName;

    @ApiModelProperty("工作流引擎")
    private String approvalEngine;
    @ApiModelProperty("工作流引擎名称")
    private String approvalEngineName;

    @ApiModelProperty("流程定义Key")
    private String approvalKey;

    @ApiModelProperty("审批扩展信息")
    private Map<String, Object> approvalJson;

    @ApiModelProperty(value = "是否已发布")
    private Boolean published;

    @ApiModelProperty("发布应用编码")
    private String appCode;
    private String appName;

    @ApiModelProperty("发布后菜单编码")
    private String menuCode;
    private String menuName;

    @ApiModelProperty(value = "发布后的菜单")
    private List<IdCodeNameParam> menus;

    @ApiModelProperty(value = "是否已部署")
    private Boolean deployed;
}
