package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:06
 */
@Repository
public interface BoModelRepository extends JpaRepository<DynamicBoModelDO, Long>,
        QuerydslPredicateExecutor<DynamicBoModelDO> {
    @Transactional
    @Modifying
    @Query("update DynamicBoModelDO d set d.creationTable = ?1 where d.boModelCode = ?2")
    int updateCreationTableByBoModelCode( Boolean creationTable,String boModelCode);
    void deleteByBoModelCode(String boModelCode);

    Optional<DynamicBoModelDO> findByBoModelCode(String boModelCode);
}