package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicExportParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportResult;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 19:34
 */
public interface DynamicBoApiService {
    /**
     * 插入数据到数据库
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param entityData 包含要插入的数据的Map
     * @return 返回一个ApiResult对象，包含插入操作的结果
     */
    ApiResult<Object> insert(String boModelCode, Map<String, Object> entityData);

    /**
     * 更新数据库中的数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param id 要更新的记录的ID
     * @param entityData 包含要更新的数据的Map
     * @return 返回一个ApiResult对象，包含更新操作影响的行数
     */
    ApiResult<Integer> update(String boModelCode, Long id, Map<String, Object> entityData);

    /**
     * 根据条件查询数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param queryParam 包含查询条件的DynamicFieldQueryParam对象
     * @return 返回一个包含查询结果的ApiResult对象
     */
    ApiResult<Page<?>> queryPage(String boModelCode, DynamicFieldQueryParam queryParam);

    /**
     * 根据ID获取数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param id 要获取的记录的ID
     * @return 返回一个包含查询结果的Map的ApiResult对象
     */
    ApiResult<Map> getById(String boModelCode, Long id);

    /**
     * 动态导出数据
     * @param tableName 要导出的数据表名
     * @param dynamicExportParam 包含导出参数的DynamicExportParam对象
     * @param response HTTP响应对象，用于将导出的数据返回给客户端
     * @throws IOException 如果导出过程中发生IO错误
     */
    void dynamicExport(String tableName, DynamicExportParam dynamicExportParam, HttpServletResponse response) throws IOException;

    /**
     * 动态导入数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param file 要导入的文件
     * @return 返回一个包含导入结果的ApiResult对象
     * @throws IOException 如果导入过程中发生IO错误
     */
    ApiResult<DynamicImportResult> dynamicImport(String boModelCode, MultipartFile file) throws IOException;

    /**
     * 根据ID删除数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param id 要删除的记录的ID
     * @return 返回一个ApiResult对象，表示删除操作的结果
     */
    ApiResult<?> delete(String boModelCode, Long id);

    /**
     * 批量删除数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param ids 要删除的记录的ID列表
     * @return 返回一个ApiResult对象，表示删除操作的结果
     */
    ApiResult<?> deleteBatch(String boModelCode, List<Long> ids);

    /**
     * 批量插入数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param entityDataList 包含要插入的数据的Map列表
     * @return 返回一个ApiResult对象，包含插入操作的结果
     */
    ApiResult<Object> insertBatch(String boModelCode, List<Map<String, Object>> entityDataList);

    /**
     * 批量更新数据
     * @param boModelCode 业务对象模型代码，用于识别具体的业务对象
     * @param longMapMap 包含要更新的数据的Map，其中key为记录的ID，value为包含更新内容的Map
     * @return 返回一个ApiResult对象，包含更新操作影响的行数
     */
    ApiResult<Integer> updateBatch(String boModelCode, Map<Long, Map<String, Object>> longMapMap);

}
