package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorUpdateParam;
import com.querydsl.core.types.Predicate;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:29
 */
public interface DynamicConfiguratorService {
    static Predicate getPredicateByConfiguratorQueryParam(ConfiguratorQueryParam configuratorParam) {
        var QDO = QDynamicConfiguratorDO.dynamicConfiguratorDO;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.dynamicConfiguratorCode::eq, configuratorParam.getDynamicConfiguratorCode())
                .and(QDO.dynamicConfiguratorName::eq, configuratorParam.getDynamicConfiguratorName())
                .and(QDO.dynamicConfiguratorStatus::eq, configuratorParam.getDynamicConfiguratorStatus())
                .and(QDO.dynamicConfiguratorType::eq, configuratorParam.getDynamicConfiguratorType())
                .and(QDO.layoutTemplateCode::eq, configuratorParam.getLayoutTemplateCode())
                .and(QDO.layoutTemplateName::eq, configuratorParam.getLayoutTemplateName())
                .getPredicate();
        return predicate;

    }

    ApiResult<Long> createConfigurator(ConfiguratorSaveParam configuratorParam);

    DynamicConfiguratorDO getConfiguratorById(Long id);
    DynamicConfiguratorDO getConfiguratorByCode(String configuratorCode);

    ApiResult<Boolean> updateConfigurator(Long id, ConfiguratorUpdateParam configuratorDetails);

    void deleteConfigurator(Long id);

    ApiResult<PagingVO<DynamicConfiguratorDO>> searchConfigurators(ConfiguratorQueryParam configuratorParam);

    ApiResult<List<DynamicConfiguratorDO>> searchConfiguratorList(ConfiguratorQueryParam configuratorParam);


}