/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.data.support.audit.CustomAuditUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.AnnotationUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.core.provider.IdGenerator;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbAuditFields;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbAuditFieldService;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DbAuditFieldServiceImpl
implements DbAuditFieldService {
    private static final Logger log = LoggerFactory.getLogger(DbAuditFieldServiceImpl.class);
    private final TenantClientProvider tenantClientProvider;

    public DbAuditFieldServiceImpl(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void fillInsertAuditFields(Map<String, Object> entityData) {
        DbAuditFields dbAuditFields = new DbAuditFields();
        dbAuditFields = (DbAuditFields)((Object)CustomAuditUtil.markCreated((Object)((Object)dbAuditFields)));
        Long aLong = IdGenerator.generateLong();
        dbAuditFields.setId(aLong);
        if (dbAuditFields != null) {
            DbAuditFieldServiceImpl.setFieldsToMap(entityData, dbAuditFields);
        }
    }

    @Override
    public void fillUpdateAuditFields(Map<String, Object> entityData) {
        DbAuditFields dbAuditFields = new DbAuditFields();
        if ((dbAuditFields = (DbAuditFields)((Object)CustomAuditUtil.markModified((Object)((Object)dbAuditFields)))) != null) {
            DbAuditFieldServiceImpl.setFieldsToMap(entityData, dbAuditFields);
        }
    }

    @Override
    public Long getCurrentUserId() {
        return SecurityContextUtil.currentUser().getUserId();
    }

    @Override
    public Long getCurrentTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant == null) {
            return -1L;
        }
        return this.tenantClientProvider.getCurrentTenant().getId();
    }

    @Override
    public List<Field> getAuditFields() {
        Field[] fields = new Field[]{DSL.field((Name)DSL.name((String)"id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"tenant_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"belong_org_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"tenant_org_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"remark"), (DataType)SQLDataType.VARCHAR((int)2000)), DSL.field((Name)DSL.name((String)"create_user_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"creator"), (DataType)SQLDataType.VARCHAR((int)200)), DSL.field((Name)DSL.name((String)"create_time"), (DataType)SQLDataType.LOCALDATETIME), DSL.field((Name)DSL.name((String)"modify_user_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"updater"), (DataType)SQLDataType.VARCHAR((int)200)), DSL.field((Name)DSL.name((String)"modify_time"), (DataType)SQLDataType.LOCALDATETIME), DSL.field((Name)DSL.name((String)"delete_flag"), (DataType)SQLDataType.INTEGER), DSL.field((Name)DSL.name((String)"audit_data_version"), (DataType)SQLDataType.INTEGER), DSL.field((Name)DSL.name((String)"sec_bu_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"sec_user_id"), (DataType)SQLDataType.BIGINT), DSL.field((Name)DSL.name((String)"sec_ou_id"), (DataType)SQLDataType.BIGINT)};
        return Arrays.asList(fields);
    }

    private static void setFieldsToMap(Map<String, Object> entityData, DbAuditFields dbAuditFields) {
        java.lang.reflect.Field[] fields;
        for (java.lang.reflect.Field field : fields = AnnotationUtil.getAllFields(((Object)((Object)dbAuditFields)).getClass())) {
            if (DbAuditFieldServiceImpl.isExcludedField(field)) continue;
            field.setAccessible(true);
            try {
                Object value = field.get((Object)dbAuditFields);
                if (value == null) continue;
                entityData.put(DbAuditFieldServiceImpl.camelCaseToUnderscore(field.getName()), value);
            }
            catch (IllegalAccessException e) {
                log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static boolean isExcludedField(java.lang.reflect.Field field) {
        return field.getName().equals("serialVersionUID");
    }

    private static String camelCaseToUnderscore(String camelCaseString) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCaseString.length(); ++i) {
            char currentChar = camelCaseString.charAt(i);
            if (Character.isUpperCase(currentChar) && i != 0) {
                result.append("_");
            }
            result.append(Character.toLowerCase(currentChar));
        }
        return result.toString();
    }
}

