package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAddViewJsonParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:23
 */
@RestController
@RequestMapping("/dynamic/boModel")
@Api(value = "动态业务模型-模型管理", tags = {"动态业务模型-模型管理"})
public class DynamicBoModelController {

    @Autowired
    private DynamicBoModelService boModelService;

    @PostMapping("/create")
    @ApiOperation(value = "创建模型", notes = "创建模型")
    public ApiResult<Long> createBoModel(@RequestBody @Valid BoModelSaveParam boModelParam) {
        return boModelService.createBoModel(boModelParam);
    }


    @GetMapping("/code/{boModelCode}")
    @ApiOperation(value = "模型查询", notes = "模型查询")
    public ApiResult<DynamicBoModelDO> getBoModelByCode(@PathVariable String boModelCode) {
        var oboModel = boModelService.getBoModelByCode(boModelCode);
        return ApiResult.ok(oboModel);
    }
    @GetMapping("/id/{boModelId}")
    @ApiOperation(value = "模型查询", notes = "模型查询")
    public ApiResult<DynamicBoModelDO> getBoModelById(@PathVariable Long boModelId) {
        var oboModel = boModelService.getBoModelById(boModelId);
        return ApiResult.ok(oboModel);
    }

    @PutMapping("/{boModelCode}/update")
    @ApiOperation(value = "模型更新", notes = "模型更新")
    public ApiResult<Boolean> updateBoModelByCode(@PathVariable String boModelCode, @RequestBody @Valid BoModelUpdateParam boModelDetails) {
        return boModelService.updateBoModel(boModelCode, boModelDetails);
    }
    @PutMapping("/code/{boModeId}/update")
    @ApiOperation(value = "模型更新", notes = "模型更新")
    public ApiResult<Boolean> updateBoModelById(@PathVariable Long boModeId, @RequestBody @Valid BoModelUpdateParam boModelDetails) {
        return boModelService.updateBoModelById(boModeId, boModelDetails);
    }

    @DeleteMapping("/code/{boModelCode}/delete")
    public ApiResult<Boolean> deleteBoModel(@PathVariable String boModelCode) {
        boModelService.deleteBoModel(boModelCode);
        return ApiResult.ok();
    }

    @DeleteMapping("/id/{boModelId}/delete")
    public ApiResult<Boolean> deleteBoModelById(@PathVariable Long boModelId) {
        boModelService.deleteBoModelById(boModelId);
        return ApiResult.ok();
    }


    @PostMapping("/query/page")
    public ApiResult<PagingVO<DynamicBoModelDO>> queryBoModels(@RequestBody BoModelQueryParam boModelParam) {
        var pagingVO = boModelService.searchBoModels(boModelParam);
        return ApiResult.ok(pagingVO);
    }

    @PostMapping("/query/list")
    public ApiResult<List<DynamicBoModelDO>> queryBoModelList(@RequestBody BoModelQueryParam boModelParam) {
        var list = boModelService.searchBoModelList(boModelParam);
        return ApiResult.ok(list);
    }
    @GetMapping("/getBoModelVoByCode/{boModelCode}")
    @ApiOperation(value = "查询模型和模型字段", notes = "查询模型和模型字段")
    public ApiResult<DynamicBoModelVo> getBoModelVoByCode(@PathVariable String boModelCode) {
        return ApiResult.ok(boModelService.getBoModelVoByCode(boModelCode));
    }

    @PostMapping("/addFormJson")
    @ApiOperation(value = "模型添加表单配置", notes = "模型添加表单配置")
    public ApiResult<String> addFormJson(@RequestBody @Valid BoModelAddViewJsonParam param) {
        return boModelService.updateBoModelFormJson(param);
    }
    @PostMapping("/addListPageJson")
    @ApiOperation(value = "模型添加列表配置", notes = "模型添加列表配置")
    public ApiResult<String> addListPageJson(@RequestBody @Valid BoModelAddViewJsonParam param) {
        return boModelService.updateBoModelListPageJson(param);
    }
}