package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAndConfiguratorRelation;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorDeleteParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorRelationBoModelParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.ConfiguratorRelationBoModelVO;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorBoModelRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 13:46
 */

@RestController
@RequestMapping("/dynamic/configurator/boModel")
@Api(value = "配置能力-配置与Bo关系", tags = {"配置能力-配置与Bo关系"})
public class DynamicConfiguratorBoModelRelationController {

    @Autowired
    private DynamicConfiguratorBoModelRelationService service;

    @PostMapping("/createBoModelAndConfigurator")
    @ApiOperation(value = "创建业务对象并和配置能力维护关系", notes = "创建业务对象并和配置能力维护关系")
    public ApiResult<Long> createBoModelAndConfigurator(@RequestBody @Valid BoModelAndConfiguratorRelation boModelParam) {
        return service.createBoModelAndConfigurator(boModelParam);
    }

    @PostMapping("/boModelAndConfiguratorRelation")
    @ApiOperation(value = "创建业务对象和配置能力关系维护", notes = "创建业务对象和配置能力关系维护")
    public ApiResult<String> boModelAndConfiguratorRelation(@RequestBody @Valid BoModelAndConfiguratorRelation boModelParam) {
        return service.boModelAndConfiguratorRelation(boModelParam);
    }

    @PostMapping("/removeBoModelAndConfiguratorRelation")
    @ApiOperation(value = "移除关系", notes = "移除关系")
    public ApiResult<String> removeBoModelAndConfiguratorRelation(@RequestBody @Valid BoModelAndConfiguratorRelation boModelParam) {
        return service.removeBoModelAndConfiguratorRelation(boModelParam);
    }
    @DeleteMapping ("/deleteConfigurator")
    @ApiOperation(value = "删除配置信息并级联关系和模块与字段", notes = "删除配置信息并级联关系和模块与字段")
    public ApiResult<Boolean> deleteConfigurator(@RequestBody ConfiguratorDeleteParam configuratorDeleteParam) {
         service.deleteConfigurator(configuratorDeleteParam.getConfiguratorId());
         return ApiResult.ok(true);
    }


    @PostMapping("/getConfiguratorRelationBoModel")
    @ApiOperation(value = "返回配置模块和关系的业务模型数据", notes = "返回配置模块和关系的业务模型数据")
    public ApiResult<ConfiguratorRelationBoModelVO> getConfiguratorRelationBoModel(@RequestBody @Valid ConfiguratorRelationBoModelParam param) {
        return service.getConfiguratorRelationBoModel(param);
    }

}
