package com.elitescloud.cloudt.lowcode.dynamic.model;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 11:47
 */
@Data
public class TableModel {
    private String name; // 数据库表名
    private String description; // 表的描述信息
    private List<FieldModel> fields; // 表中包含的字段列表
    private List<RelationModel> relations; // 表与其他表的关系列表

    // 构造函数
    public TableModel(String name, String description) {
        this.name = name;
        this.description = description;
        this.fields = new ArrayList<>();
        this.relations = new ArrayList<>();
    }

    public TableModel(String name, String description, List<FieldModel> fields, ArrayList<RelationModel> relations) {
        this.name = name;
        this.description = description;
        this.fields =fields;
        this.relations = relations;
    }

    // 添加字段
    public void addField(FieldModel field) {
        fields.add(field);
    }

    // 添加关系
    public void addRelation(RelationModel relation) {
        relations.add(relation);
    }

}
