package com.elitescloud.cloudt.lowcode.dynamic.model.bo;

import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 模型表的列.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/25
 */
@Getter
@Setter
public class DynamicModelColumnBO implements Serializable {
    private static final long serialVersionUID = 6669616031465451945L;

    /**
     * 模型编码
     */
    private String basicModuleCode;
    /**
     * 字段标识
     */
    private String basicKey;

    /**
     * 显示名称
     */
    private String basicName;

    /**
     * 字段描述
     */
    private String basicDescription;

    /**
     * 字段类型
     */
    private BoModelFieldTypeEnum basicType;

    /**
     * 默认值
     */
    private String basicDefaultValue;

    /**
     * 字段长度
     */
    private Integer dbFieldLength;

    /**
     * 字段精度
     */
    private Integer dbFieldPrecision;

    /**
     * 小数位数
     */
    private Integer dbFieldScale;

    /**
     * 是否为主键
     */
    private Boolean primaryKey;

    /**
     * 字段是否可为空
     */
    private Boolean dbFieldNullable;

    /**
     * 字段值是否唯一
     */
    private Boolean dbFieldUnique;

    /**
     * 是否创建索引
     */
    private Boolean dbFieldIndex;

    /**
     * 顺序
     */
    private Integer basicDisplayOrder;
}
